package api

import (
	"context"
	"net/http"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/agentcfg"
)

const (
	AgentConfigurationAPIPath = "/api/v4/internal/kubernetes/agent_configuration"
)

func PostAgentkConfiguration(ctx context.Context, client gitlab.ClientInterface, agentKey api.AgentKey,
	config *agentcfg.ConfigurationFile, configCommitID string, opts ...gitlab.DoOption) error {
	return client.Do(ctx,
		joinOpts(opts,
			gitlab.WithMethod(http.MethodPost),
			gitlab.WithPath(AgentConfigurationAPIPath),
			gitlab.WithJWT(true),
			gitlab.WithProtoJSONRequestBody(&AgentConfigurationRequest{
				AgentId:             agentKey.ID,
				AgentConfig:         config,
				AgentConfigCommitId: configCommitID,
			}),
			gitlab.WithResponseHandler(gitlab.NoContentResponseHandler()),
		)...,
	)
}
