package rpc

import (
	"testing"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testhelpers"
)

func TestValidation_Valid(t *testing.T) {
	tests := []testhelpers.ValidTestcase{
		{
			Name: "EnvironmentTemplateInfo",
			Valid: &EnvironmentTemplateInfo{
				AgentName:    "abc",
				TemplateName: "abc",
			},
		},
	}
	testhelpers.AssertValid(t, tests)
}

func TestValidation_Invalid(t *testing.T) {
	tests := []testhelpers.InvalidTestcase{
		{
			ErrString: "validation errors:\n - agent_name: invalid agent name\n - template_name: value length must be at least 1 bytes",
			Invalid:   &EnvironmentTemplateInfo{},
		},
	}
	testhelpers.AssertInvalid(t, tests)
}
