package v1

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/storage"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	Version    = "v1"
	APIVersion = storage.GroupName + "/" + Version
)

var (
	CSIStorageCapacityTypeMeta = tm("CSIStorageCapacity")
	VolumeAttachmentTypeMeta   = tm("VolumeAttachment")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
