package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	GroupName  = "apps"
	Version    = "v1"
	APIVersion = GroupName + "/" + Version
)

var (
	DeploymentTypeMeta  = tm("Deployment")
	ReplicaSetTypeMeta  = tm("ReplicaSet")
	DaemonSetTypeMeta   = tm("DaemonSet")
	StatefulSetTypeMeta = tm("StatefulSet")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
