package v1

import (
	sourceapi "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/github.com/fluxcd/source-controller/api"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	Version    = "v1"
	APIVersion = sourceapi.GroupName + "/" + Version
)

var (
	GitRepositoryTypeMeta  = tm("GitRepository")
	OCIRepositoryTypeMeta  = tm("OCIRepository")
	HelmRepositoryTypeMeta = tm("HelmRepository")
	HelmChartTypeMeta      = tm("HelmChart")
	BucketTypeMeta         = tm("Bucket")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
