package api

import (
	"k8s.io/apimachinery/pkg/runtime/schema"
)

const (
	GroupName = "notification.toolkit.fluxcd.io"
)

var (
	ProviderGK = gk("Provider")
	Alert      = gk("Alert")
	Receiver   = gk("Receiver")
)

func gk(kind string) schema.GroupKind {
	return schema.GroupKind{
		Group: GroupName,
		Kind:  kind,
	}
}
