package agent

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testhelpers"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testlogger"
)

func TestModule_Run(t *testing.T) {
	ctx, cancel := context.WithCancel(t.Context())
	defer cancel()

	calledRegister := false
	calledUnregister := false

	m := &Module[int32]{
		Log:        testlogger.New(t),
		PollConfig: testhelpers.NewPollConfig(0),
		Register: func(ctx context.Context) error {
			cancel()
			calledRegister = true
			return nil
		},
		Unregister: func(ctx context.Context) error {
			calledUnregister = true
			return nil
		},
	}
	_ = m.Run(ctx, nil)

	assert.True(t, calledRegister)
	assert.True(t, calledUnregister)
}
