package api

import (
	"context"
	"net/http"
	"strconv"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
)

const (
	updateCIJobAPIPathPrefix = "/api/v4/jobs/"
)

func UpdateCIJobAPIPath(jobID int64) string {
	return updateCIJobAPIPathPrefix + strconv.FormatInt(jobID, 10)
}

func UpdateCIJob(ctx context.Context, client gitlab.ClientInterface, jobID int64, req *UpdateCIJobAPIRequest, opts ...gitlab.DoOption) error {
	err := client.Do(ctx,
		joinOpts(opts,
			gitlab.WithMethod(http.MethodPut),
			gitlab.WithPath(UpdateCIJobAPIPath(jobID)),
			gitlab.WithProtoJSONRequestBody(req),
			gitlab.WithResponseHandler(gitlab.NoContentResponseHandler()), // checks for OK status code
		)...,
	)

	return err
}
