package api

import (
	"context"
	"net/http"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitlab"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/httpz"
)

const (
	GetRunnerControllersForJobAdmissionAPIPath = "/api/v4/internal/ci/job_router/runner_controllers/job_admission"
)

func GetRunnerControllersForJobAdmission(ctx context.Context, client gitlab.ClientInterface, runnerToken api.AgentToken, opts ...gitlab.DoOption) (*GetRunnerControllersForJobAdmissionAPIResponse, error) {
	resp := &GetRunnerControllersForJobAdmissionAPIResponse{}
	err := client.Do(ctx,
		joinOpts(opts,
			gitlab.WithPath(GetRunnerControllersForJobAdmissionAPIPath),
			gitlab.WithHeader(http.Header{
				httpz.RunnerTokenHeader: []string{string(runnerToken)},
			}),
			gitlab.WithJWT(true),
			gitlab.WithResponseHandler(gitlab.ProtoJSONResponseHandlerWithStructuredErrReason(resp)),
		)...,
	)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
