package api

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/server_api"
)

func (a *GetAgentkInfoResponse) ToAgentkInfo() *server_api.AgentkInfo {
	return &server_api.AgentkInfo{
		Key: api.AgentKey{
			ID:   a.AgentId,
			Type: api.AgentTypeKubernetes,
		},
		ProjectID:     a.ProjectId,
		Name:          a.AgentName,
		GitalyInfo:    a.GitalyInfo,
		Repository:    a.GitalyRepository.ToGitalyRepository(),
		DefaultBranch: a.DefaultBranch,
	}
}

func (a *GetAgentkInfoResponse) ToAgentInfo() server_api.AgentInfo {
	return a.ToAgentkInfo()
}

func (a *GetAgentwInfoResponse) ToAgentwInfo() *server_api.AgentwInfo {
	return &server_api.AgentwInfo{
		Key: api.AgentKey{
			ID:   a.WorkspaceId,
			Type: api.AgentTypeWorkspace,
		},
	}
}

func (a *GetAgentwInfoResponse) ToAgentInfo() server_api.AgentInfo {
	return a.ToAgentwInfo()
}

func (a *GetRunnerControllerInfoResponse) ToRunnerControllerInfo() *server_api.RunnerControllerInfo {
	return &server_api.RunnerControllerInfo{
		Key: api.AgentKey{
			ID:   a.AgentId,
			Type: api.AgentTypeRunnerController,
		},
	}
}

func (a *GetRunnerControllerInfoResponse) ToAgentInfo() server_api.AgentInfo {
	return a.ToRunnerControllerInfo()
}

func (p *GetRepositoryInfoResponse) ToProjectInfo() *server_api.ProjectInfo {
	return &server_api.ProjectInfo{
		ProjectID:     p.ProjectId,
		GitalyInfo:    p.GitalyInfo,
		Repository:    p.GitalyRepository.ToGitalyRepository(),
		DefaultBranch: p.DefaultBranch,
	}
}
