package ruby

import (
	"testing"

	agent_tracker_rpc "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_tracker/rpc"
	autoflow_rpc "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/autoflow/rpc"
	configuration_project_rpc "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/configuration_project/rpc"
	managed_resources_rpc "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/managed_resources/rpc"
	notifications_rpc "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/notifications/rpc"
	server_info_rpc "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/server_info/rpc"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/testing/testproto"
	"google.golang.org/protobuf/reflect/protoreflect"
)

// Sometimes Rails exposes types that we export to it via REST/Graphql API.
// Hence, we must ensure json_name is set correctly for consistency.
func TestJSONNameSetOnResponseMessages(t *testing.T) {
	// This should match the RPC list in BUILD.bazel.
	fileDescr := []protoreflect.FileDescriptor{
		agent_tracker_rpc.File_internal_module_agent_tracker_rpc_rpc_proto,
		autoflow_rpc.File_internal_module_autoflow_rpc_rpc_proto,
		configuration_project_rpc.File_internal_module_configuration_project_rpc_rpc_proto,
		managed_resources_rpc.File_internal_module_managed_resources_rpc_rpc_proto,
		notifications_rpc.File_internal_module_notifications_rpc_rpc_proto,
		server_info_rpc.File_internal_module_server_info_rpc_rpc_proto,
	}
	for _, fd := range fileDescr {
		svcs := fd.Services()
		for svcIdx := range svcs.Len() {
			svc := svcs.Get(svcIdx)
			methods := svc.Methods()
			for methodIdx := range methods.Len() {
				method := methods.Get(methodIdx)
				testproto.AssertHasJSONNameSetRecursive(t, method.Output())
			}
		}
	}
}
