package grpctool

import (
	"gitlab.com/gitlab-org/cluster-integration/tunnel/tool/streamvisitor"
	"google.golang.org/protobuf/reflect/protoreflect"
)

const (
	HTTPRequestHeaderFieldNumber      protoreflect.FieldNumber = 1
	HTTPRequestDataFieldNumber        protoreflect.FieldNumber = 2
	HTTPRequestTrailerFieldNumber     protoreflect.FieldNumber = 3
	HTTPRequestUpgradeDataFieldNumber protoreflect.FieldNumber = 4

	HTTPResponseHeaderFieldNumber      protoreflect.FieldNumber = 1
	HTTPResponseDataFieldNumber        protoreflect.FieldNumber = 2
	HTTPResponseTrailerFieldNumber     protoreflect.FieldNumber = 3
	HTTPResponseUpgradeDataFieldNumber protoreflect.FieldNumber = 4
)

var (
	HTTPRequestStreamVisitor  = streamvisitor.NewLazyStreamVisitor(&HttpRequest{})
	HTTPResponseStreamVisitor = streamvisitor.NewLazyStreamVisitor(&HttpResponse{})
)
