package server_api //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitaly/vendored/gitalypb"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/entity"
)

// AgentkInfo contains information about an agentk.
type AgentkInfo struct {
	// Key is the agent's type and id in the database.
	Key api.AgentKey
	// ProjectID is the id of the configuration project of the agent.
	ProjectID int64
	// Name is the agent's name.
	// Can contain only /a-z\d-/
	Name       string
	GitalyInfo *entity.GitalyInfo
	Repository *gitalypb.Repository
	// DefaultBranch is the name of the default branch in the agent's configuration repository.
	DefaultBranch string
}

func (a *AgentkInfo) AgentKey() api.AgentKey {
	return a.Key
}
