package agentk

import (
	"context"

	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

type informer interface {
	Start(ctx context.Context) error
	Get(namespace, name string) (*unstructured.Unstructured, error)
	ListAll() []*unstructured.Unstructured
	Stop()
}

/*
parsedWorkspace is our internal view on the full unstructured.Unstructured k8s resource.
We use parsedWorkspace for logic like checking if the latest change has been persisted
or whether we terminated the workspace
*/
type parsedWorkspace struct {
	Name              string
	Namespace         string
	ResourceVersion   string
	K8sDeploymentInfo map[string]any
}

// workspaceInfoKey is used as an identifier for workspace data when preparing rails payload
type workspaceInfoKey struct {
	Name      string
	Namespace string
}
