package watch_graph //nolint:staticcheck

import (
	gatewayapiv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/sigs.k8s.io/gateway-api/apis/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectGatewayClassV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[gatewayapiv1.GatewayClass](obj)
	if err != nil {
		return err
	}

	if o.Spec.ParametersRef != nil {
		vx.collectGatewayParametersRefV1Arcs(o.Spec.ParametersRef, ReferenceArcType)
	}

	return nil
}
