package watch_graph //nolint:staticcheck

import (
	"k8s.io/apimachinery/pkg/runtime/schema"
)

// We don't want to depend on the packages with constants just for a single constant (group name), so just define GKs here.

var (
	clusterTrustBundleGK = schema.GroupKind{
		Group: "certificates.k8s.io",
		Kind:  "ClusterTrustBundle",
	}
	priorityClassGK = schema.GroupKind{
		Group: "scheduling.k8s.io",
		Kind:  "PriorityClass",
	}
	runtimeClassGK = schema.GroupKind{
		Group: "node.k8s.io",
		Kind:  "RuntimeClass",
	}
	resourceClaimGK = schema.GroupKind{
		Group: "resource.k8s.io",
		Kind:  "ResourceClaim",
	}
	resourceClaimTemplateGK = schema.GroupKind{
		Group: "resource.k8s.io",
		Kind:  "ResourceClaimTemplate",
	}
)
