package server

import (
	"time"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_registrar"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_registrar/agentk_rpc"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_registrar/agentw_rpc"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_registrar/runnerc_rpc"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/agent_tracker"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modserver"
)

const (
	registerAgentEventName = "register_agent_at_kas"
	registerTimeout        = 5 * time.Second
)

type Factory struct {
	AgentRegisterer agent_tracker.ExpiringRegisterer
}

func (f *Factory) New(config *modserver.Config) (modserver.Module, error) {
	eventTracker := config.EventTracker.RegisterEvent(registerAgentEventName)

	agentk_rpc.RegisterAgentRegistrarServer(config.AgentServer, &agentkServer{
		agentRegisterer:           f.AgentRegisterer,
		registerAgentEventTracker: eventTracker,
	})

	agentw_rpc.RegisterAgentRegistrarServer(config.AgentServer, &agentwServer{
		agentRegisterer:           f.AgentRegisterer,
		registerAgentEventTracker: eventTracker,
	})

	runnerc_rpc.RegisterAgentRegistrarServer(config.AgentServer, &runnerControllerServer{
		agentRegisterer:           f.AgentRegisterer,
		registerAgentEventTracker: eventTracker,
	})

	return nil, nil
}

func (f *Factory) Name() string {
	return agent_registrar.ModuleName
}
