package it

import (
	"context"
	"net/http"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/gitaly/vendored/gitalypb"
	"google.golang.org/grpc"
)

// GitalyAPI is a subset of gitalypb.CommitServiceServer.
// We cannot generate a mock for the real interface since it has a private method. So, have to have this crutch.
// See https://github.com/uber-go/mock/issues/64.
type GitalyAPI interface {
	GetTreeEntries(*gitalypb.GetTreeEntriesRequest, grpc.ServerStreamingServer[gitalypb.GetTreeEntriesResponse]) error
	LastCommitForPath(context.Context, *gitalypb.LastCommitForPathRequest) (*gitalypb.LastCommitForPathResponse, error)
	TreeEntry(*gitalypb.TreeEntryRequest, grpc.ServerStreamingServer[gitalypb.TreeEntryResponse]) error
}

type GitLabAPI interface {
	GetAgentInfo(http.ResponseWriter, *http.Request)
	PostAgentConfiguration(http.ResponseWriter, *http.Request)
	GetAllowedAgents(http.ResponseWriter, *http.Request)
	GetReceptiveAgents(http.ResponseWriter, *http.Request)
}
