# Protocol Documentation
<a name="top"></a>

## Table of Contents

- [internal/agentwcfg/agentwcfg.proto](#internal_agentwcfg_agentwcfg-proto)
    - [AgentConfiguration](#gitlab-agent-agentwcfg-AgentConfiguration)
    - [GoogleProfiler](#gitlab-agent-agentwcfg-GoogleProfiler)
    - [Logging](#gitlab-agent-agentwcfg-Logging)
    - [Observability](#gitlab-agent-agentwcfg-Observability)
  
    - [log_level_enum](#gitlab-agent-agentwcfg-log_level_enum)
  
- [Scalar Value Types](#scalar-value-types)



<a name="internal_agentwcfg_agentwcfg-proto"></a>
<p align="right"><a href="#top">Top</a></p>

## internal/agentwcfg/agentwcfg.proto



<a name="gitlab-agent-agentwcfg-AgentConfiguration"></a>

### AgentConfiguration
AgentConfiguration represents configuration for agentw.


| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| agent_id | [int64](#int64) |  | GitLab-wide unique id of the agent for the given agent_type. |
| observability | [Observability](#gitlab-agent-agentwcfg-Observability) |  | Configuration related to all things observability. This is about the agent itself. |






<a name="gitlab-agent-agentwcfg-GoogleProfiler"></a>

### GoogleProfiler



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| enabled | [bool](#bool) |  |  |
| project_id | [string](#string) |  |  |
| credentials_file | [string](#string) |  |  |
| debug_logging | [bool](#bool) |  |  |






<a name="gitlab-agent-agentwcfg-Logging"></a>

### Logging



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| level | [log_level_enum](#gitlab-agent-agentwcfg-log_level_enum) |  |  |
| grpc_level | [log_level_enum](#gitlab-agent-agentwcfg-log_level_enum) | optional | optional to be able to tell when not set and use a different default value. |






<a name="gitlab-agent-agentwcfg-Observability"></a>

### Observability



| Field | Type | Label | Description |
| ----- | ---- | ----- | ----------- |
| logging | [Logging](#gitlab-agent-agentwcfg-Logging) |  |  |
| google_profiler | [GoogleProfiler](#gitlab-agent-agentwcfg-GoogleProfiler) |  |  |





 


<a name="gitlab-agent-agentwcfg-log_level_enum"></a>

### log_level_enum


| Name | Number | Description |
| ---- | ------ | ----------- |
| info | 0 | default value must be 0 |
| debug | 1 |  |
| warn | 2 |  |
| error | 3 |  |


 

 

 



## Scalar Value Types

| .proto Type | Notes | C++ | Java | Python | Go | C# | PHP | Ruby |
| ----------- | ----- | --- | ---- | ------ | -- | -- | --- | ---- |
| <a name="double" /> double |  | double | double | float | float64 | double | float | Float |
| <a name="float" /> float |  | float | float | float | float32 | float | float | Float |
| <a name="int32" /> int32 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint32 instead. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="int64" /> int64 | Uses variable-length encoding. Inefficient for encoding negative numbers – if your field is likely to have negative values, use sint64 instead. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="uint32" /> uint32 | Uses variable-length encoding. | uint32 | int | int/long | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="uint64" /> uint64 | Uses variable-length encoding. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum or Fixnum (as required) |
| <a name="sint32" /> sint32 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int32s. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sint64" /> sint64 | Uses variable-length encoding. Signed int value. These more efficiently encode negative numbers than regular int64s. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="fixed32" /> fixed32 | Always four bytes. More efficient than uint32 if values are often greater than 2^28. | uint32 | int | int | uint32 | uint | integer | Bignum or Fixnum (as required) |
| <a name="fixed64" /> fixed64 | Always eight bytes. More efficient than uint64 if values are often greater than 2^56. | uint64 | long | int/long | uint64 | ulong | integer/string | Bignum |
| <a name="sfixed32" /> sfixed32 | Always four bytes. | int32 | int | int | int32 | int | integer | Bignum or Fixnum (as required) |
| <a name="sfixed64" /> sfixed64 | Always eight bytes. | int64 | long | int/long | int64 | long | integer/string | Bignum |
| <a name="bool" /> bool |  | bool | boolean | boolean | bool | bool | boolean | TrueClass/FalseClass |
| <a name="string" /> string | A string must always contain UTF-8 encoded or 7-bit ASCII text. | string | String | str/unicode | string | string | string | String (UTF-8) |
| <a name="bytes" /> bytes | May contain any arbitrary sequence of bytes. | string | ByteString | str | []byte | ByteString | string | String (ASCII-8BIT) |

