package syncz

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSyncSubscriptions(t *testing.T) {
	s := NewSyncSubscriptions[int]()

	var got int

	stop := s.On(func(i int) {
		got = i
	})
	assert.Equal(t, 1, s.Len())
	s.Dispatch(123)

	assert.Equal(t, 123, got)

	stop()
	assert.Zero(t, s.Len())

	s.Dispatch(321)

	assert.Equal(t, 123, got)
}

func BenchmarkSyncSubscriptions(b *testing.B) {
	var ss SyncSubscriptions[int64]
	cb := func(i int64) {}
	b.ReportAllocs()
	var stop func()
	for b.Loop() {
		stop = ss.On(cb)
	}
	_ = stop
}
