package server

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modserver"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/runner"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/runner/rpc"
)

type Factory struct{}

func (f *Factory) New(config *modserver.Config) (modserver.Module, error) {
	rpc.RegisterJobRouterServer(config.AgentServer, &server{
		gitlabClient: config.GitLabClient,
	})
	return nil, nil
}

func (f *Factory) Name() string {
	return runner.ModuleName
}
