package server

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
)

func Test_GetAuthorizedProxyUserCacheKeyFunc_AllFieldsUsed(t *testing.T) {
	keyFunc := getAuthorizedProxyUserCacheKey("any-prefix")

	redisKeys := map[string]struct{}{}
	redisKeys[keyFunc(proxyUserCacheKey{
		agentKey:   api.AgentKey{ID: 1, Type: api.AgentTypeKubernetes},
		accessType: "any",
		accessKey:  "any",
		csrfToken:  "any",
	})] = struct{}{}
	redisKeys[keyFunc(proxyUserCacheKey{
		accessType: "any",
		accessKey:  "any",
	})] = struct{}{}
	redisKeys[keyFunc(proxyUserCacheKey{
		agentKey:  api.AgentKey{ID: 1, Type: api.AgentTypeKubernetes},
		accessKey: "any",
		csrfToken: "any",
	})] = struct{}{}
	redisKeys[keyFunc(proxyUserCacheKey{
		agentKey:   api.AgentKey{ID: 1, Type: api.AgentTypeKubernetes},
		accessType: "any",
		csrfToken:  "any",
	})] = struct{}{}

	assert.Len(t, redisKeys, 4)
}
