//go:build !ignore_autogenerated

// Code generated by remove-junk-from-types-now-9000; DO NOT EDIT.
// Generator module: gitlab.com/gitlab-org/cluster-integration/remove-junk-from-types-now-9000
// Generator version: v0.0.0-20251110001802-ac4f0ee40261
// Configuration file: no_junk_config.json
// Source module: sigs.k8s.io/gateway-api
// Source module version: v1.3.0
// Source module query:
// Source module sum: h1:q6okN+/UKDATola4JY7zXzx40WO4VISk7i9DIfOvr9M=
// Source module package: apis/v1

package v1

// BackendObjectReference defines how an ObjectReference that is
// specific to BackendRef. It includes a few additional fields and features
// than a regular ObjectReference.
//
// Note that when a namespace different than the local namespace is specified, a
// ReferenceGrant object is required in the referent namespace to allow that
// namespace's owner to accept the reference. See the ReferenceGrant
// documentation for details.
//
// The API object must be valid in the cluster; the Group and Kind must
// be registered in the cluster for this reference to be valid.
//
// References to objects with invalid Group and Kind are not valid, and must
// be rejected by the implementation, with appropriate Conditions set
// on the containing object.
//
// +kubebuilder:validation:XValidation:message="Must have port for Service reference",rule="(size(self.group) == 0 && self.kind == 'Service') ? has(self.port) : true"
type BackendObjectReference struct {
	// Group is the group of the referent. For example, "gateway.networking.k8s.io".
	// When unspecified or empty string, core API group is inferred.
	//
	// +optional
	// +kubebuilder:default=""
	Group *Group `json:"group,omitempty"`
	// Kind is the Kubernetes resource kind of the referent. For example
	// "Service".
	//
	// Defaults to "Service" when not specified.
	//
	// ExternalName services can refer to CNAME DNS records that may live
	// outside of the cluster and as such are difficult to reason about in
	// terms of conformance. They also may not be safe to forward to (see
	// CVE-2021-25740 for more information). Implementations SHOULD NOT
	// support ExternalName Services.
	//
	// Support: Core (Services with a type other than ExternalName)
	//
	// Support: Implementation-specific (Services with type ExternalName)
	//
	// +optional
	// +kubebuilder:default=Service
	Kind *Kind `json:"kind,omitempty"`
	// Name is the name of the referent.
	Name ObjectName `json:"name"`
	// Namespace is the namespace of the backend. When unspecified, the local
	// namespace is inferred.
	//
	// Note that when a namespace different than the local namespace is specified,
	// a ReferenceGrant object is required in the referent namespace to allow that
	// namespace's owner to accept the reference. See the ReferenceGrant
	// documentation for details.
	//
	// Support: Core
	//
	// +optional
	Namespace *Namespace `json:"namespace,omitempty"`
}

// BackendRef defines how a Route should forward a request to a Kubernetes
// resource.
//
// Note that when a namespace different than the local namespace is specified, a
// ReferenceGrant object is required in the referent namespace to allow that
// namespace's owner to accept the reference. See the ReferenceGrant
// documentation for details.
//
// <gateway:experimental:description>
//
// When the BackendRef points to a Kubernetes Service, implementations SHOULD
// honor the appProtocol field if it is set for the target Service Port.
//
// Implementations supporting appProtocol SHOULD recognize the Kubernetes
// Standard Application Protocols defined in KEP-3726.
//
// If a Service appProtocol isn't specified, an implementation MAY infer the
// backend protocol through its own means. Implementations MAY infer the
// protocol from the Route type referring to the backend Service.
//
// If a Route is not able to send traffic to the backend using the specified
// protocol then the backend is considered invalid. Implementations MUST set the
// "ResolvedRefs" condition to "False" with the "UnsupportedProtocol" reason.
//
// </gateway:experimental:description>
//
// Note that when the BackendTLSPolicy object is enabled by the implementation,
// there are some extra rules about validity to consider here. See the fields
// where this struct is used for more information about the exact behavior.
type BackendRef struct {
	// BackendObjectReference references a Kubernetes object.
	BackendObjectReference `json:",inline"`
}

// CommonRouteSpec defines the common attributes that all Routes MUST include
// within their spec.
type CommonRouteSpec struct {
	// ParentRefs references the resources (usually Gateways) that a Route wants
	// to be attached to. Note that the referenced parent resource needs to
	// allow this for the attachment to be complete. For Gateways, that means
	// the Gateway needs to allow attachment from Routes of this kind and
	// namespace. For Services, that means the Service must either be in the same
	// namespace for a "producer" route, or the mesh implementation must support
	// and allow "consumer" routes for the referenced Service. ReferenceGrant is
	// not applicable for governing ParentRefs to Services - it is not possible to
	// create a "producer" route for a Service in a different namespace from the
	// Route.
	//
	// There are two kinds of parent resources with "Core" support:
	//
	// * Gateway (Gateway conformance profile)
	// * Service (Mesh conformance profile, ClusterIP Services only)
	//
	// This API may be extended in the future to support additional kinds of parent
	// resources.
	//
	// ParentRefs must be _distinct_. This means either that:
	//
	//   - They select different objects.  If this is the case, then parentRef
	//     entries are distinct. In terms of fields, this means that the
	//     multi-part key defined by `group`, `kind`, `namespace`, and `name` must
	//     be unique across all parentRef entries in the Route.
	//   - They do not select different objects, but for each optional field used,
	//     each ParentRef that selects the same object must set the same set of
	//     optional fields to different values. If one ParentRef sets a
	//     combination of optional fields, all must set the same combination.
	//
	// Some examples:
	//
	//   - If one ParentRef sets `sectionName`, all ParentRefs referencing the
	//     same object must also set `sectionName`.
	//   - If one ParentRef sets `port`, all ParentRefs referencing the same
	//     object must also set `port`.
	//   - If one ParentRef sets `sectionName` and `port`, all ParentRefs
	//     referencing the same object must also set `sectionName` and `port`.
	//
	// It is possible to separately reference multiple distinct objects that may
	// be collapsed by an implementation. For example, some implementations may
	// choose to merge compatible Gateway Listeners together. If that is the
	// case, the list of routes attached to those resources should also be
	// merged.
	//
	// Note that for ParentRefs that cross namespace boundaries, there are specific
	// rules. Cross-namespace references are only valid if they are explicitly
	// allowed by something in the namespace they are referring to. For example,
	// Gateway has the AllowedRoutes field, and ReferenceGrant provides a
	// generic way to enable other kinds of cross-namespace reference.
	//
	// <gateway:experimental:description>
	// ParentRefs from a Route to a Service in the same namespace are "producer"
	// routes, which apply default routing rules to inbound connections from
	// any namespace to the Service.
	//
	// ParentRefs from a Route to a Service in a different namespace are
	// "consumer" routes, and these routing rules are only applied to outbound
	// connections originating from the same namespace as the Route, for which
	// the intended destination of the connections are a Service targeted as a
	// ParentRef of the Route.
	// </gateway:experimental:description>
	//
	// +optional
	// +kubebuilder:validation:MaxItems=32
	// <gateway:standard:validation:XValidation:message="sectionName must be specified when parentRefs includes 2 or more references to the same parent",rule="self.all(p1, self.all(p2, p1.group == p2.group && p1.kind == p2.kind && p1.name == p2.name && (((!has(p1.__namespace__) || p1.__namespace__ == ”) && (!has(p2.__namespace__) || p2.__namespace__ == ”)) || (has(p1.__namespace__) && has(p2.__namespace__) && p1.__namespace__ == p2.__namespace__ )) ? ((!has(p1.sectionName) || p1.sectionName == ”) == (!has(p2.sectionName) || p2.sectionName == ”)) : true))">
	// <gateway:standard:validation:XValidation:message="sectionName must be unique when parentRefs includes 2 or more references to the same parent",rule="self.all(p1, self.exists_one(p2, p1.group == p2.group && p1.kind == p2.kind && p1.name == p2.name && (((!has(p1.__namespace__) || p1.__namespace__ == ”) && (!has(p2.__namespace__) || p2.__namespace__ == ”)) || (has(p1.__namespace__) && has(p2.__namespace__) && p1.__namespace__ == p2.__namespace__ )) && (((!has(p1.sectionName) || p1.sectionName == ”) && (!has(p2.sectionName) || p2.sectionName == ”)) || (has(p1.sectionName) && has(p2.sectionName) && p1.sectionName == p2.sectionName))))">
	// <gateway:experimental:validation:XValidation:message="sectionName or port must be specified when parentRefs includes 2 or more references to the same parent",rule="self.all(p1, self.all(p2, p1.group == p2.group && p1.kind == p2.kind && p1.name == p2.name && (((!has(p1.__namespace__) || p1.__namespace__ == ”) && (!has(p2.__namespace__) || p2.__namespace__ == ”)) || (has(p1.__namespace__) && has(p2.__namespace__) && p1.__namespace__ == p2.__namespace__)) ? ((!has(p1.sectionName) || p1.sectionName == ”) == (!has(p2.sectionName) || p2.sectionName == ”) && (!has(p1.port) || p1.port == 0) == (!has(p2.port) || p2.port == 0)): true))">
	// <gateway:experimental:validation:XValidation:message="sectionName or port must be unique when parentRefs includes 2 or more references to the same parent",rule="self.all(p1, self.exists_one(p2, p1.group == p2.group && p1.kind == p2.kind && p1.name == p2.name && (((!has(p1.__namespace__) || p1.__namespace__ == ”) && (!has(p2.__namespace__) || p2.__namespace__ == ”)) || (has(p1.__namespace__) && has(p2.__namespace__) && p1.__namespace__ == p2.__namespace__ )) && (((!has(p1.sectionName) || p1.sectionName == ”) && (!has(p2.sectionName) || p2.sectionName == ”)) || ( has(p1.sectionName) && has(p2.sectionName) && p1.sectionName == p2.sectionName)) && (((!has(p1.port) || p1.port == 0) && (!has(p2.port) || p2.port == 0)) || (has(p1.port) && has(p2.port) && p1.port == p2.port))))">
	ParentRefs []ParentReference `json:"parentRefs,omitempty"`
}

// FrontendTLSValidation holds configuration information that can be used to validate
// the frontend initiating the TLS connection
type FrontendTLSValidation struct {
	// CACertificateRefs contains one or more references to
	// Kubernetes objects that contain TLS certificates of
	// the Certificate Authorities that can be used
	// as a trust anchor to validate the certificates presented by the client.
	//
	// A single CA certificate reference to a Kubernetes ConfigMap
	// has "Core" support.
	// Implementations MAY choose to support attaching multiple CA certificates to
	// a Listener, but this behavior is implementation-specific.
	//
	// Support: Core - A single reference to a Kubernetes ConfigMap
	// with the CA certificate in a key named `ca.crt`.
	//
	// Support: Implementation-specific (More than one reference, or other kinds
	// of resources).
	//
	// References to a resource in a different namespace are invalid UNLESS there
	// is a ReferenceGrant in the target namespace that allows the certificate
	// to be attached. If a ReferenceGrant does not allow this reference, the
	// "ResolvedRefs" condition MUST be set to False for this listener with the
	// "RefNotPermitted" reason.
	//
	// +kubebuilder:validation:MaxItems=8
	// +kubebuilder:validation:MinItems=1
	CACertificateRefs []ObjectReference `json:"caCertificateRefs,omitempty"`
}

// GRPCBackendRef defines how a GRPCRoute forwards a gRPC request.
//
// Note that when a namespace different than the local namespace is specified, a
// ReferenceGrant object is required in the referent namespace to allow that
// namespace's owner to accept the reference. See the ReferenceGrant
// documentation for details.
//
// <gateway:experimental:description>
//
// When the BackendRef points to a Kubernetes Service, implementations SHOULD
// honor the appProtocol field if it is set for the target Service Port.
//
// Implementations supporting appProtocol SHOULD recognize the Kubernetes
// Standard Application Protocols defined in KEP-3726.
//
// If a Service appProtocol isn't specified, an implementation MAY infer the
// backend protocol through its own means. Implementations MAY infer the
// protocol from the Route type referring to the backend Service.
//
// If a Route is not able to send traffic to the backend using the specified
// protocol then the backend is considered invalid. Implementations MUST set the
// "ResolvedRefs" condition to "False" with the "UnsupportedProtocol" reason.
//
// </gateway:experimental:description>
type GRPCBackendRef struct {
	// BackendRef is a reference to a backend to forward matched requests to.
	//
	// A BackendRef can be invalid for the following reasons. In all cases, the
	// implementation MUST ensure the `ResolvedRefs` Condition on the Route
	// is set to `status: False`, with a Reason and Message that indicate
	// what is the cause of the error.
	//
	// A BackendRef is invalid if:
	//
	//   - It refers to an unknown or unsupported kind of resource. In this
	//     case, the Reason MUST be set to `InvalidKind` and Message of the
	//     Condition MUST explain which kind of resource is unknown or unsupported.
	//
	//   - It refers to a resource that does not exist. In this case, the Reason MUST
	//     be set to `BackendNotFound` and the Message of the Condition MUST explain
	//     which resource does not exist.
	//
	//   - It refers a resource in another namespace when the reference has not been
	//     explicitly allowed by a ReferenceGrant (or equivalent concept). In this
	//     case, the Reason MUST be set to `RefNotPermitted` and the Message of the
	//     Condition MUST explain which cross-namespace reference is not allowed.
	//
	// Support: Core for Kubernetes Service
	//
	// Support: Extended for Kubernetes ServiceImport
	//
	// Support: Implementation-specific for any other resource
	//
	// Support for weight: Core
	//
	// +optional
	BackendRef `json:",inline"`
	// Filters defined at this level MUST be executed if and only if the
	// request is being forwarded to the backend defined here.
	//
	// Support: Implementation-specific (For broader support of filters, use the
	// Filters field in GRPCRouteRule.)
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	// +kubebuilder:validation:XValidation:message="RequestHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'RequestHeaderModifier').size() <= 1"
	// +kubebuilder:validation:XValidation:message="ResponseHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'ResponseHeaderModifier').size() <= 1"
	Filters []GRPCRouteFilter `json:"filters,omitempty"`
}

// GRPCRoute provides a way to route gRPC requests. This includes the capability
// to match requests by hostname, gRPC service, gRPC method, or HTTP/2 header.
// Filters can be used to specify additional processing steps. Backends specify
// where matching requests will be routed.
//
// GRPCRoute falls under extended support within the Gateway API. Within the
// following specification, the word "MUST" indicates that an implementation
// supporting GRPCRoute must conform to the indicated requirement, but an
// implementation not supporting this route type need not follow the requirement
// unless explicitly indicated.
//
// Implementations supporting `GRPCRoute` with the `HTTPS` `ProtocolType` MUST
// accept HTTP/2 connections without an initial upgrade from HTTP/1.1, i.e. via
// ALPN. If the implementation does not support this, then it MUST set the
// "Accepted" condition to "False" for the affected listener with a reason of
// "UnsupportedProtocol".  Implementations MAY also accept HTTP/2 connections
// with an upgrade from HTTP/1.
//
// Implementations supporting `GRPCRoute` with the `HTTP` `ProtocolType` MUST
// support HTTP/2 over cleartext TCP (h2c,
// https://www.rfc-editor.org/rfc/rfc7540#section-3.1) without an initial
// upgrade from HTTP/1.1, i.e. with prior knowledge
// (https://www.rfc-editor.org/rfc/rfc7540#section-3.4). If the implementation
// does not support this, then it MUST set the "Accepted" condition to "False"
// for the affected listener with a reason of "UnsupportedProtocol".
// Implementations MAY also accept HTTP/2 connections with an upgrade from
// HTTP/1, i.e. without prior knowledge.
type GRPCRoute struct {
	// Spec defines the desired state of GRPCRoute.
	Spec GRPCRouteSpec `json:"spec,omitempty"`
}

// GRPCRouteFilter defines processing steps that must be completed during the
// request or response lifecycle. GRPCRouteFilters are meant as an extension
// point to express processing that may be done in Gateway implementations. Some
// examples include request or response modification, implementing
// authentication strategies, rate-limiting, and traffic shaping. API
// guarantee/conformance is defined based on the type of the filter.
//
// +kubebuilder:validation:XValidation:message="filter.requestHeaderModifier must be nil if the filter.type is not RequestHeaderModifier",rule="!(has(self.requestHeaderModifier) && self.type != 'RequestHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.requestHeaderModifier must be specified for RequestHeaderModifier filter.type",rule="!(!has(self.requestHeaderModifier) && self.type == 'RequestHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.responseHeaderModifier must be nil if the filter.type is not ResponseHeaderModifier",rule="!(has(self.responseHeaderModifier) && self.type != 'ResponseHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.responseHeaderModifier must be specified for ResponseHeaderModifier filter.type",rule="!(!has(self.responseHeaderModifier) && self.type == 'ResponseHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.requestMirror must be nil if the filter.type is not RequestMirror",rule="!(has(self.requestMirror) && self.type != 'RequestMirror')"
// +kubebuilder:validation:XValidation:message="filter.requestMirror must be specified for RequestMirror filter.type",rule="!(!has(self.requestMirror) && self.type == 'RequestMirror')"
// +kubebuilder:validation:XValidation:message="filter.extensionRef must be nil if the filter.type is not ExtensionRef",rule="!(has(self.extensionRef) && self.type != 'ExtensionRef')"
// +kubebuilder:validation:XValidation:message="filter.extensionRef must be specified for ExtensionRef filter.type",rule="!(!has(self.extensionRef) && self.type == 'ExtensionRef')"
type GRPCRouteFilter struct {
	// RequestMirror defines a schema for a filter that mirrors requests.
	// Requests are sent to the specified destination, but responses from
	// that destination are ignored.
	//
	// This filter can be used multiple times within the same rule. Note that
	// not all implementations will be able to support mirroring to multiple
	// backends.
	//
	// Support: Extended
	//
	// +optional
	//
	// +kubebuilder:validation:XValidation:message="Only one of percent or fraction may be specified in HTTPRequestMirrorFilter",rule="!(has(self.percent) && has(self.fraction))"
	RequestMirror *HTTPRequestMirrorFilter `json:"requestMirror,omitempty"`
	// ExtensionRef is an optional, implementation-specific extension to the
	// "filter" behavior.  For example, resource "myroutefilter" in group
	// "networking.example.net"). ExtensionRef MUST NOT be used for core and
	// extended filters.
	//
	// Support: Implementation-specific
	//
	// This filter can be used multiple times within the same rule.
	// +optional
	ExtensionRef *LocalObjectReference `json:"extensionRef,omitempty"`
}

// GRPCRouteRule defines the semantics for matching a gRPC request based on
// conditions (matches), processing it (filters), and forwarding the request to
// an API object (backendRefs).
type GRPCRouteRule struct {
	// Filters define the filters that are applied to requests that match
	// this rule.
	//
	// The effects of ordering of multiple behaviors are currently unspecified.
	// This can change in the future based on feedback during the alpha stage.
	//
	// Conformance-levels at this level are defined based on the type of filter:
	//
	//   - ALL core filters MUST be supported by all implementations that support
	//     GRPCRoute.
	//   - Implementers are encouraged to support extended filters.
	//   - Implementation-specific custom filters have no API guarantees across
	//     implementations.
	//
	// Specifying the same filter multiple times is not supported unless explicitly
	// indicated in the filter.
	//
	// If an implementation cannot support a combination of filters, it must clearly
	// document that limitation. In cases where incompatible or unsupported
	// filters are specified and cause the `Accepted` condition to be set to status
	// `False`, implementations may use the `IncompatibleFilters` reason to specify
	// this configuration error.
	//
	// Support: Core
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	// +kubebuilder:validation:XValidation:message="RequestHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'RequestHeaderModifier').size() <= 1"
	// +kubebuilder:validation:XValidation:message="ResponseHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'ResponseHeaderModifier').size() <= 1"
	Filters []GRPCRouteFilter `json:"filters,omitempty"`
	// BackendRefs defines the backend(s) where matching requests should be
	// sent.
	//
	// Failure behavior here depends on how many BackendRefs are specified and
	// how many are invalid.
	//
	// If *all* entries in BackendRefs are invalid, and there are also no filters
	// specified in this route rule, *all* traffic which matches this rule MUST
	// receive an `UNAVAILABLE` status.
	//
	// See the GRPCBackendRef definition for the rules about what makes a single
	// GRPCBackendRef invalid.
	//
	// When a GRPCBackendRef is invalid, `UNAVAILABLE` statuses MUST be returned for
	// requests that would have otherwise been routed to an invalid backend. If
	// multiple backends are specified, and some are invalid, the proportion of
	// requests that would otherwise have been routed to an invalid backend
	// MUST receive an `UNAVAILABLE` status.
	//
	// For example, if two backends are specified with equal weights, and one is
	// invalid, 50 percent of traffic MUST receive an `UNAVAILABLE` status.
	// Implementations may choose how that 50 percent is determined.
	//
	// Support: Core for Kubernetes Service
	//
	// Support: Implementation-specific for any other resource
	//
	// Support for weight: Core
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	BackendRefs []GRPCBackendRef `json:"backendRefs,omitempty"`
}

// GRPCRouteSpec defines the desired state of GRPCRoute
type GRPCRouteSpec struct {
	CommonRouteSpec `json:",inline"`
	// Rules are a list of GRPC matchers, filters and actions.
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	// +kubebuilder:validation:XValidation:message="While 16 rules and 64 matches per rule are allowed, the total number of matches across all rules in a route must be less than 128",rule="(self.size() > 0 ? (has(self[0].matches) ? self[0].matches.size() : 0) : 0) + (self.size() > 1 ? (has(self[1].matches) ? self[1].matches.size() : 0) : 0) + (self.size() > 2 ? (has(self[2].matches) ? self[2].matches.size() : 0) : 0) + (self.size() > 3 ? (has(self[3].matches) ? self[3].matches.size() : 0) : 0) + (self.size() > 4 ? (has(self[4].matches) ? self[4].matches.size() : 0) : 0) + (self.size() > 5 ? (has(self[5].matches) ? self[5].matches.size() : 0) : 0) + (self.size() > 6 ? (has(self[6].matches) ? self[6].matches.size() : 0) : 0) + (self.size() > 7 ? (has(self[7].matches) ? self[7].matches.size() : 0) : 0) + (self.size() > 8 ? (has(self[8].matches) ? self[8].matches.size() : 0) : 0) + (self.size() > 9 ? (has(self[9].matches) ? self[9].matches.size() : 0) : 0) + (self.size() > 10 ? (has(self[10].matches) ? self[10].matches.size() : 0) : 0) + (self.size() > 11 ? (has(self[11].matches) ? self[11].matches.size() : 0) : 0) + (self.size() > 12 ? (has(self[12].matches) ? self[12].matches.size() : 0) : 0) + (self.size() > 13 ? (has(self[13].matches) ? self[13].matches.size() : 0) : 0) + (self.size() > 14 ? (has(self[14].matches) ? self[14].matches.size() : 0) : 0) + (self.size() > 15 ? (has(self[15].matches) ? self[15].matches.size() : 0) : 0) <= 128"
	// <gateway:experimental:validation:XValidation:message="Rule name must be unique within the route",rule="self.all(l1, !has(l1.name) || self.exists_one(l2, has(l2.name) && l1.name == l2.name))">
	Rules []GRPCRouteRule `json:"rules,omitempty"`
}

// Gateway represents an instance of a service-traffic handling infrastructure
// by binding Listeners to a set of IP addresses.
type Gateway struct {
	// Spec defines the desired state of Gateway.
	Spec GatewaySpec `json:"spec"`
}

// GatewayBackendTLS describes backend TLS configuration for gateway.
type GatewayBackendTLS struct {
	// ClientCertificateRef is a reference to an object that contains a Client
	// Certificate and the associated private key.
	//
	// References to a resource in different namespace are invalid UNLESS there
	// is a ReferenceGrant in the target namespace that allows the certificate
	// to be attached. If a ReferenceGrant does not allow this reference, the
	// "ResolvedRefs" condition MUST be set to False for this listener with the
	// "RefNotPermitted" reason.
	//
	// ClientCertificateRef can reference to standard Kubernetes resources, i.e.
	// Secret, or implementation-specific custom resources.
	//
	// This setting can be overridden on the service level by use of BackendTLSPolicy.
	//
	// Support: Core
	//
	// +optional
	// <gateway:experimental>
	ClientCertificateRef *SecretObjectReference `json:"clientCertificateRef,omitempty"`
}

// GatewayClass describes a class of Gateways available to the user for creating
// Gateway resources.
//
// It is recommended that this resource be used as a template for Gateways. This
// means that a Gateway is based on the state of the GatewayClass at the time it
// was created and changes to the GatewayClass or associated parameters are not
// propagated down to existing Gateways. This recommendation is intended to
// limit the blast radius of changes to GatewayClass or associated parameters.
// If implementations choose to propagate GatewayClass changes to existing
// Gateways, that MUST be clearly documented by the implementation.
//
// Whenever one or more Gateways are using a GatewayClass, implementations SHOULD
// add the `gateway-exists-finalizer.gateway.networking.k8s.io` finalizer on the
// associated GatewayClass. This ensures that a GatewayClass associated with a
// Gateway is not deleted while in use.
//
// GatewayClass is a Cluster level resource.
type GatewayClass struct {
	// Spec defines the desired state of GatewayClass.
	Spec GatewayClassSpec `json:"spec"`
}

// GatewayClassSpec reflects the configuration of a class of Gateways.
type GatewayClassSpec struct {
	// ParametersRef is a reference to a resource that contains the configuration
	// parameters corresponding to the GatewayClass. This is optional if the
	// controller does not require any additional configuration.
	//
	// ParametersRef can reference a standard Kubernetes resource, i.e. ConfigMap,
	// or an implementation-specific custom resource. The resource can be
	// cluster-scoped or namespace-scoped.
	//
	// If the referent cannot be found, refers to an unsupported kind, or when
	// the data within that resource is malformed, the GatewayClass SHOULD be
	// rejected with the "Accepted" status condition set to "False" and an
	// "InvalidParameters" reason.
	//
	// A Gateway for this GatewayClass may provide its own `parametersRef`. When both are specified,
	// the merging behavior is implementation specific.
	// It is generally recommended that GatewayClass provides defaults that can be overridden by a Gateway.
	//
	// Support: Implementation-specific
	//
	// +optional
	ParametersRef *ParametersReference `json:"parametersRef,omitempty"`
}

// GatewayInfrastructure defines infrastructure level attributes about a Gateway instance.
type GatewayInfrastructure struct {
	// ParametersRef is a reference to a resource that contains the configuration
	// parameters corresponding to the Gateway. This is optional if the
	// controller does not require any additional configuration.
	//
	// # This follows the same semantics as GatewayClass's `parametersRef`, but on a per-Gateway basis
	//
	// The Gateway's GatewayClass may provide its own `parametersRef`. When both are specified,
	// the merging behavior is implementation specific.
	// It is generally recommended that GatewayClass provides defaults that can be overridden by a Gateway.
	//
	// If the referent cannot be found, refers to an unsupported kind, or when
	// the data within that resource is malformed, the Gateway SHOULD be
	// rejected with the "Accepted" status condition set to "False" and an
	// "InvalidParameters" reason.
	//
	// Support: Implementation-specific
	//
	// +optional
	ParametersRef *LocalParametersReference `json:"parametersRef,omitempty"`
}

// GatewaySpec defines the desired state of Gateway.
//
// Not all possible combinations of options specified in the Spec are
// valid. Some invalid configurations can be caught synchronously via CRD
// validation, but there are many cases that will require asynchronous
// signaling via the GatewayStatus block.
type GatewaySpec struct {
	// GatewayClassName used for this Gateway. This is the name of a
	// GatewayClass resource.
	GatewayClassName ObjectName `json:"gatewayClassName"`
	// Listeners associated with this Gateway. Listeners define
	// logical endpoints that are bound on this Gateway's addresses.
	// At least one Listener MUST be specified.
	//
	// ## Distinct Listeners
	//
	// Each Listener in a set of Listeners (for example, in a single Gateway)
	// MUST be _distinct_, in that a traffic flow MUST be able to be assigned to
	// exactly one listener. (This section uses "set of Listeners" rather than
	// "Listeners in a single Gateway" because implementations MAY merge configuration
	// from multiple Gateways onto a single data plane, and these rules _also_
	// apply in that case).
	//
	// Practically, this means that each listener in a set MUST have a unique
	// combination of Port, Protocol, and, if supported by the protocol, Hostname.
	//
	// Some combinations of port, protocol, and TLS settings are considered
	// Core support and MUST be supported by implementations based on the objects
	// they support:
	//
	// # HTTPRoute
	//
	// 1. HTTPRoute, Port: 80, Protocol: HTTP
	// 2. HTTPRoute, Port: 443, Protocol: HTTPS, TLS Mode: Terminate, TLS keypair provided
	//
	// # TLSRoute
	//
	// 1. TLSRoute, Port: 443, Protocol: TLS, TLS Mode: Passthrough
	//
	// "Distinct" Listeners have the following property:
	//
	// **The implementation can match inbound requests to a single distinct
	// Listener**.
	//
	// When multiple Listeners share values for fields (for
	// example, two Listeners with the same Port value), the implementation
	// can match requests to only one of the Listeners using other
	// Listener fields.
	//
	// When multiple listeners have the same value for the Protocol field, then
	// each of the Listeners with matching Protocol values MUST have different
	// values for other fields.
	//
	// The set of fields that MUST be different for a Listener differs per protocol.
	// The following rules define the rules for what fields MUST be considered for
	// Listeners to be distinct with each protocol currently defined in the
	// Gateway API spec.
	//
	// The set of listeners that all share a protocol value MUST have _different_
	// values for _at least one_ of these fields to be distinct:
	//
	// * **HTTP, HTTPS, TLS**: Port, Hostname
	// * **TCP, UDP**: Port
	//
	// One **very** important rule to call out involves what happens when an
	// implementation:
	//
	//   - Supports TCP protocol Listeners, as well as HTTP, HTTPS, or TLS protocol
	//     Listeners, and
	//   - sees HTTP, HTTPS, or TLS protocols with the same `port` as one with TCP
	//     Protocol.
	//
	// In this case all the Listeners that share a port with the
	// TCP Listener are not distinct and so MUST NOT be accepted.
	//
	// If an implementation does not support TCP Protocol Listeners, then the
	// previous rule does not apply, and the TCP Listeners SHOULD NOT be
	// accepted.
	//
	// Note that the `tls` field is not used for determining if a listener is distinct, because
	// Listeners that _only_ differ on TLS config will still conflict in all cases.
	//
	// ### Listeners that are distinct only by Hostname
	//
	// When the Listeners are distinct based only on Hostname, inbound request
	// hostnames MUST match from the most specific to least specific Hostname
	// values to choose the correct Listener and its associated set of Routes.
	//
	// Exact matches MUST be processed before wildcard matches, and wildcard
	// matches MUST be processed before fallback (empty Hostname value)
	// matches. For example, `"foo.example.com"` takes precedence over
	// `"*.example.com"`, and `"*.example.com"` takes precedence over `""`.
	//
	// Additionally, if there are multiple wildcard entries, more specific
	// wildcard entries must be processed before less specific wildcard entries.
	// For example, `"*.foo.example.com"` takes precedence over `"*.example.com"`.
	//
	// The precise definition here is that the higher the number of dots in the
	// hostname to the right of the wildcard character, the higher the precedence.
	//
	// The wildcard character will match any number of characters _and dots_ to
	// the left, however, so `"*.example.com"` will match both
	// `"foo.bar.example.com"` _and_ `"bar.example.com"`.
	//
	// ## Handling indistinct Listeners
	//
	// If a set of Listeners contains Listeners that are not distinct, then those
	// Listeners are _Conflicted_, and the implementation MUST set the "Conflicted"
	// condition in the Listener Status to "True".
	//
	// The words "indistinct" and "conflicted" are considered equivalent for the
	// purpose of this documentation.
	//
	// Implementations MAY choose to accept a Gateway with some Conflicted
	// Listeners only if they only accept the partial Listener set that contains
	// no Conflicted Listeners.
	//
	// Specifically, an implementation MAY accept a partial Listener set subject to
	// the following rules:
	//
	//   - The implementation MUST NOT pick one conflicting Listener as the winner.
	//     ALL indistinct Listeners must not be accepted for processing.
	//   - At least one distinct Listener MUST be present, or else the Gateway effectively
	//     contains _no_ Listeners, and must be rejected from processing as a whole.
	//
	// The implementation MUST set a "ListenersNotValid" condition on the
	// Gateway Status when the Gateway contains Conflicted Listeners whether or
	// not they accept the Gateway. That Condition SHOULD clearly
	// indicate in the Message which Listeners are conflicted, and which are
	// Accepted. Additionally, the Listener status for those listeners SHOULD
	// indicate which Listeners are conflicted and not Accepted.
	//
	// ## General Listener behavior
	//
	// Note that, for all distinct Listeners, requests SHOULD match at most one Listener.
	// For example, if Listeners are defined for "foo.example.com" and "*.example.com", a
	// request to "foo.example.com" SHOULD only be routed using routes attached
	// to the "foo.example.com" Listener (and not the "*.example.com" Listener).
	//
	// This concept is known as "Listener Isolation", and it is an Extended feature
	// of Gateway API. Implementations that do not support Listener Isolation MUST
	// clearly document this, and MUST NOT claim support for the
	// `GatewayHTTPListenerIsolation` feature.
	//
	// Implementations that _do_ support Listener Isolation SHOULD claim support
	// for the Extended `GatewayHTTPListenerIsolation` feature and pass the associated
	// conformance tests.
	//
	// ## Compatible Listeners
	//
	// A Gateway's Listeners are considered _compatible_ if:
	//
	//  1. They are distinct.
	//  2. The implementation can serve them in compliance with the Addresses
	//     requirement that all Listeners are available on all assigned
	//     addresses.
	//
	// Compatible combinations in Extended support are expected to vary across
	// implementations. A combination that is compatible for one implementation
	// may not be compatible for another.
	//
	// For example, an implementation that cannot serve both TCP and UDP listeners
	// on the same address, or cannot mix HTTPS and generic TLS listens on the same port
	// would not consider those cases compatible, even though they are distinct.
	//
	// Implementations MAY merge separate Gateways onto a single set of
	// Addresses if all Listeners across all Gateways are compatible.
	//
	// In a future release the MinItems=1 requirement MAY be dropped.
	//
	// Support: Core
	//
	// +listType=map
	// +listMapKey=name
	// +kubebuilder:validation:MinItems=1
	// +kubebuilder:validation:MaxItems=64
	// +kubebuilder:validation:XValidation:message="tls must not be specified for protocols ['HTTP', 'TCP', 'UDP']",rule="self.all(l, l.protocol in ['HTTP', 'TCP', 'UDP'] ? !has(l.tls) : true)"
	// +kubebuilder:validation:XValidation:message="tls mode must be Terminate for protocol HTTPS",rule="self.all(l, (l.protocol == 'HTTPS' && has(l.tls)) ? (l.tls.mode == ” || l.tls.mode == 'Terminate') : true)"
	// +kubebuilder:validation:XValidation:message="hostname must not be specified for protocols ['TCP', 'UDP']",rule="self.all(l, l.protocol in ['TCP', 'UDP']  ? (!has(l.hostname) || l.hostname == ”) : true)"
	// +kubebuilder:validation:XValidation:message="Listener name must be unique within the Gateway",rule="self.all(l1, self.exists_one(l2, l1.name == l2.name))"
	// +kubebuilder:validation:XValidation:message="Combination of port, protocol and hostname must be unique for each listener",rule="self.all(l1, self.exists_one(l2, l1.port == l2.port && l1.protocol == l2.protocol && (has(l1.hostname) && has(l2.hostname) ? l1.hostname == l2.hostname : !has(l1.hostname) && !has(l2.hostname))))"
	Listeners []Listener `json:"listeners"`
	// Infrastructure defines infrastructure level attributes about this Gateway instance.
	//
	// Support: Extended
	//
	// +optional
	Infrastructure *GatewayInfrastructure `json:"infrastructure,omitempty"`
	// BackendTLS configures TLS settings for when this Gateway is connecting to
	// backends with TLS.
	//
	// Support: Core
	//
	// +optional
	// <gateway:experimental>
	BackendTLS *GatewayBackendTLS `json:"backendTLS,omitempty"`
}

// GatewayTLSConfig describes a TLS configuration.
//
// +kubebuilder:validation:XValidation:message="certificateRefs or options must be specified when mode is Terminate",rule="self.mode == 'Terminate' ? size(self.certificateRefs) > 0 || size(self.options) > 0 : true"
type GatewayTLSConfig struct {
	// CertificateRefs contains a series of references to Kubernetes objects that
	// contains TLS certificates and private keys. These certificates are used to
	// establish a TLS handshake for requests that match the hostname of the
	// associated listener.
	//
	// A single CertificateRef to a Kubernetes Secret has "Core" support.
	// Implementations MAY choose to support attaching multiple certificates to
	// a Listener, but this behavior is implementation-specific.
	//
	// References to a resource in different namespace are invalid UNLESS there
	// is a ReferenceGrant in the target namespace that allows the certificate
	// to be attached. If a ReferenceGrant does not allow this reference, the
	// "ResolvedRefs" condition MUST be set to False for this listener with the
	// "RefNotPermitted" reason.
	//
	// This field is required to have at least one element when the mode is set
	// to "Terminate" (default) and is optional otherwise.
	//
	// CertificateRefs can reference to standard Kubernetes resources, i.e.
	// Secret, or implementation-specific custom resources.
	//
	// Support: Core - A single reference to a Kubernetes Secret of type kubernetes.io/tls
	//
	// Support: Implementation-specific (More than one reference or other resource types)
	//
	// +optional
	// +kubebuilder:validation:MaxItems=64
	CertificateRefs []SecretObjectReference `json:"certificateRefs,omitempty"`
	// FrontendValidation holds configuration information for validating the frontend (client).
	// Setting this field will require clients to send a client certificate
	// required for validation during the TLS handshake. In browsers this may result in a dialog appearing
	// that requests a user to specify the client certificate.
	// The maximum depth of a certificate chain accepted in verification is Implementation specific.
	//
	// Support: Extended
	//
	// +optional
	// <gateway:experimental>
	FrontendValidation *FrontendTLSValidation `json:"frontendValidation,omitempty"`
}

// Group refers to a Kubernetes Group. It must either be an empty string or a
// RFC 1123 subdomain.
//
// This validation is based off of the corresponding Kubernetes validation:
// https://github.com/kubernetes/apimachinery/blob/02cfb53916346d085a6c6c7c66f882e3c6b0eca6/pkg/util/validation/validation.go#L208
//
// Valid values include:
//
// * "" - empty string implies core Kubernetes API group
// * "gateway.networking.k8s.io"
// * "foo.example.com"
//
// Invalid values include:
//
// * "example.com/bar" - "/" is an invalid character
//
// +kubebuilder:validation:MaxLength=253
// +kubebuilder:validation:Pattern=`^$|^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$`
type Group string

// HTTPBackendRef defines how a HTTPRoute forwards a HTTP request.
//
// Note that when a namespace different than the local namespace is specified, a
// ReferenceGrant object is required in the referent namespace to allow that
// namespace's owner to accept the reference. See the ReferenceGrant
// documentation for details.
//
// <gateway:experimental:description>
//
// When the BackendRef points to a Kubernetes Service, implementations SHOULD
// honor the appProtocol field if it is set for the target Service Port.
//
// Implementations supporting appProtocol SHOULD recognize the Kubernetes
// Standard Application Protocols defined in KEP-3726.
//
// If a Service appProtocol isn't specified, an implementation MAY infer the
// backend protocol through its own means. Implementations MAY infer the
// protocol from the Route type referring to the backend Service.
//
// If a Route is not able to send traffic to the backend using the specified
// protocol then the backend is considered invalid. Implementations MUST set the
// "ResolvedRefs" condition to "False" with the "UnsupportedProtocol" reason.
//
// </gateway:experimental:description>
type HTTPBackendRef struct {
	// BackendRef is a reference to a backend to forward matched requests to.
	//
	// A BackendRef can be invalid for the following reasons. In all cases, the
	// implementation MUST ensure the `ResolvedRefs` Condition on the Route
	// is set to `status: False`, with a Reason and Message that indicate
	// what is the cause of the error.
	//
	// A BackendRef is invalid if:
	//
	//   - It refers to an unknown or unsupported kind of resource. In this
	//     case, the Reason must be set to `InvalidKind` and Message of the
	//     Condition must explain which kind of resource is unknown or unsupported.
	//
	//   - It refers to a resource that does not exist. In this case, the Reason must
	//     be set to `BackendNotFound` and the Message of the Condition must explain
	//     which resource does not exist.
	//
	//   - It refers a resource in another namespace when the reference has not been
	//     explicitly allowed by a ReferenceGrant (or equivalent concept). In this
	//     case, the Reason must be set to `RefNotPermitted` and the Message of the
	//     Condition must explain which cross-namespace reference is not allowed.
	//
	//   - It refers to a Kubernetes Service that has an incompatible appProtocol
	//     for the given Route type
	//
	//   - The BackendTLSPolicy object is installed in the cluster, a BackendTLSPolicy
	//     is present that refers to the Service, and the implementation is unable
	//     to meet the requirement. At the time of writing, BackendTLSPolicy is
	//     experimental, but once it becomes standard, this will become a MUST
	//     requirement.
	//
	// Support: Core for Kubernetes Service
	//
	// Support: Implementation-specific for any other resource
	//
	// Support for weight: Core
	//
	// Support for Kubernetes Service appProtocol: Extended
	//
	// Support for BackendTLSPolicy: Experimental and ImplementationSpecific
	//
	// +optional
	BackendRef `json:",inline"`
	// Filters defined at this level should be executed if and only if the
	// request is being forwarded to the backend defined here.
	//
	// Support: Implementation-specific (For broader support of filters, use the
	// Filters field in HTTPRouteRule.)
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	// +kubebuilder:validation:XValidation:message="May specify either httpRouteFilterRequestRedirect or httpRouteFilterRequestRewrite, but not both",rule="!(self.exists(f, f.type == 'RequestRedirect') && self.exists(f, f.type == 'URLRewrite'))"
	// +kubebuilder:validation:XValidation:message="May specify either httpRouteFilterRequestRedirect or httpRouteFilterRequestRewrite, but not both",rule="!(self.exists(f, f.type == 'RequestRedirect') && self.exists(f, f.type == 'URLRewrite'))"
	// +kubebuilder:validation:XValidation:message="RequestHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'RequestHeaderModifier').size() <= 1"
	// +kubebuilder:validation:XValidation:message="ResponseHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'ResponseHeaderModifier').size() <= 1"
	// +kubebuilder:validation:XValidation:message="RequestRedirect filter cannot be repeated",rule="self.filter(f, f.type == 'RequestRedirect').size() <= 1"
	// +kubebuilder:validation:XValidation:message="URLRewrite filter cannot be repeated",rule="self.filter(f, f.type == 'URLRewrite').size() <= 1"
	Filters []HTTPRouteFilter `json:"filters,omitempty"`
}

// HTTPRequestMirrorFilter defines configuration for the RequestMirror filter.
type HTTPRequestMirrorFilter struct {
	// BackendRef references a resource where mirrored requests are sent.
	//
	// Mirrored requests must be sent only to a single destination endpoint
	// within this BackendRef, irrespective of how many endpoints are present
	// within this BackendRef.
	//
	// If the referent cannot be found, this BackendRef is invalid and must be
	// dropped from the Gateway. The controller must ensure the "ResolvedRefs"
	// condition on the Route status is set to `status: False` and not configure
	// this backend in the underlying implementation.
	//
	// If there is a cross-namespace reference to an *existing* object
	// that is not allowed by a ReferenceGrant, the controller must ensure the
	// "ResolvedRefs"  condition on the Route is set to `status: False`,
	// with the "RefNotPermitted" reason and not configure this backend in the
	// underlying implementation.
	//
	// In either error case, the Message of the `ResolvedRefs` Condition
	// should be used to provide more detail about the problem.
	//
	// Support: Extended for Kubernetes Service
	//
	// Support: Implementation-specific for any other resource
	BackendRef BackendObjectReference `json:"backendRef"`
}

// HTTPRoute provides a way to route HTTP requests. This includes the capability
// to match requests by hostname, path, header, or query param. Filters can be
// used to specify additional processing steps. Backends specify where matching
// requests should be routed.
type HTTPRoute struct {
	// Spec defines the desired state of HTTPRoute.
	Spec HTTPRouteSpec `json:"spec"`
}

// HTTPRouteFilter defines processing steps that must be completed during the
// request or response lifecycle. HTTPRouteFilters are meant as an extension
// point to express processing that may be done in Gateway implementations. Some
// examples include request or response modification, implementing
// authentication strategies, rate-limiting, and traffic shaping. API
// guarantee/conformance is defined based on the type of the filter.
//
// +kubebuilder:validation:XValidation:message="filter.requestHeaderModifier must be nil if the filter.type is not RequestHeaderModifier",rule="!(has(self.requestHeaderModifier) && self.type != 'RequestHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.requestHeaderModifier must be specified for RequestHeaderModifier filter.type",rule="!(!has(self.requestHeaderModifier) && self.type == 'RequestHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.responseHeaderModifier must be nil if the filter.type is not ResponseHeaderModifier",rule="!(has(self.responseHeaderModifier) && self.type != 'ResponseHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.responseHeaderModifier must be specified for ResponseHeaderModifier filter.type",rule="!(!has(self.responseHeaderModifier) && self.type == 'ResponseHeaderModifier')"
// +kubebuilder:validation:XValidation:message="filter.requestMirror must be nil if the filter.type is not RequestMirror",rule="!(has(self.requestMirror) && self.type != 'RequestMirror')"
// +kubebuilder:validation:XValidation:message="filter.requestMirror must be specified for RequestMirror filter.type",rule="!(!has(self.requestMirror) && self.type == 'RequestMirror')"
// +kubebuilder:validation:XValidation:message="filter.requestRedirect must be nil if the filter.type is not RequestRedirect",rule="!(has(self.requestRedirect) && self.type != 'RequestRedirect')"
// +kubebuilder:validation:XValidation:message="filter.requestRedirect must be specified for RequestRedirect filter.type",rule="!(!has(self.requestRedirect) && self.type == 'RequestRedirect')"
// +kubebuilder:validation:XValidation:message="filter.urlRewrite must be nil if the filter.type is not URLRewrite",rule="!(has(self.urlRewrite) && self.type != 'URLRewrite')"
// +kubebuilder:validation:XValidation:message="filter.urlRewrite must be specified for URLRewrite filter.type",rule="!(!has(self.urlRewrite) && self.type == 'URLRewrite')"
// <gateway:experimental:validation:XValidation:message="filter.cors must be nil if the filter.type is not CORS",rule="!(has(self.cors) && self.type != 'CORS')">
// <gateway:experimental:validation:XValidation:message="filter.cors must be specified for CORS filter.type",rule="!(!has(self.cors) && self.type == 'CORS')">
// +kubebuilder:validation:XValidation:message="filter.extensionRef must be nil if the filter.type is not ExtensionRef",rule="!(has(self.extensionRef) && self.type != 'ExtensionRef')"
// +kubebuilder:validation:XValidation:message="filter.extensionRef must be specified for ExtensionRef filter.type",rule="!(!has(self.extensionRef) && self.type == 'ExtensionRef')"
type HTTPRouteFilter struct {
	// RequestMirror defines a schema for a filter that mirrors requests.
	// Requests are sent to the specified destination, but responses from
	// that destination are ignored.
	//
	// This filter can be used multiple times within the same rule. Note that
	// not all implementations will be able to support mirroring to multiple
	// backends.
	//
	// Support: Extended
	//
	// +optional
	//
	// +kubebuilder:validation:XValidation:message="Only one of percent or fraction may be specified in HTTPRequestMirrorFilter",rule="!(has(self.percent) && has(self.fraction))"
	RequestMirror *HTTPRequestMirrorFilter `json:"requestMirror,omitempty"`
	// ExtensionRef is an optional, implementation-specific extension to the
	// "filter" behavior.  For example, resource "myroutefilter" in group
	// "networking.example.net"). ExtensionRef MUST NOT be used for core and
	// extended filters.
	//
	// This filter can be used multiple times within the same rule.
	//
	// Support: Implementation-specific
	//
	// +optional
	ExtensionRef *LocalObjectReference `json:"extensionRef,omitempty"`
}

// HTTPRouteRule defines semantics for matching an HTTP request based on
// conditions (matches), processing it (filters), and forwarding the request to
// an API object (backendRefs).
//
// +kubebuilder:validation:XValidation:message="RequestRedirect filter must not be used together with backendRefs",rule="(has(self.backendRefs) && size(self.backendRefs) > 0) ? (!has(self.filters) || self.filters.all(f, !has(f.requestRedirect))): true"
// +kubebuilder:validation:XValidation:message="When using RequestRedirect filter with path.replacePrefixMatch, exactly one PathPrefix match must be specified",rule="(has(self.filters) && self.filters.exists_one(f, has(f.requestRedirect) && has(f.requestRedirect.path) && f.requestRedirect.path.type == 'ReplacePrefixMatch' && has(f.requestRedirect.path.replacePrefixMatch))) ? ((size(self.matches) != 1 || !has(self.matches[0].path) || self.matches[0].path.type != 'PathPrefix') ? false : true) : true"
// +kubebuilder:validation:XValidation:message="When using URLRewrite filter with path.replacePrefixMatch, exactly one PathPrefix match must be specified",rule="(has(self.filters) && self.filters.exists_one(f, has(f.urlRewrite) && has(f.urlRewrite.path) && f.urlRewrite.path.type == 'ReplacePrefixMatch' && has(f.urlRewrite.path.replacePrefixMatch))) ? ((size(self.matches) != 1 || !has(self.matches[0].path) || self.matches[0].path.type != 'PathPrefix') ? false : true) : true"
// +kubebuilder:validation:XValidation:message="Within backendRefs, when using RequestRedirect filter with path.replacePrefixMatch, exactly one PathPrefix match must be specified",rule="(has(self.backendRefs) && self.backendRefs.exists_one(b, (has(b.filters) && b.filters.exists_one(f, has(f.requestRedirect) && has(f.requestRedirect.path) && f.requestRedirect.path.type == 'ReplacePrefixMatch' && has(f.requestRedirect.path.replacePrefixMatch))) )) ? ((size(self.matches) != 1 || !has(self.matches[0].path) || self.matches[0].path.type != 'PathPrefix') ? false : true) : true"
// +kubebuilder:validation:XValidation:message="Within backendRefs, When using URLRewrite filter with path.replacePrefixMatch, exactly one PathPrefix match must be specified",rule="(has(self.backendRefs) && self.backendRefs.exists_one(b, (has(b.filters) && b.filters.exists_one(f, has(f.urlRewrite) && has(f.urlRewrite.path) && f.urlRewrite.path.type == 'ReplacePrefixMatch' && has(f.urlRewrite.path.replacePrefixMatch))) )) ? ((size(self.matches) != 1 || !has(self.matches[0].path) || self.matches[0].path.type != 'PathPrefix') ? false : true) : true"
type HTTPRouteRule struct {
	// Filters define the filters that are applied to requests that match
	// this rule.
	//
	// Wherever possible, implementations SHOULD implement filters in the order
	// they are specified.
	//
	// Implementations MAY choose to implement this ordering strictly, rejecting
	// any combination or order of filters that cannot be supported. If implementations
	// choose a strict interpretation of filter ordering, they MUST clearly document
	// that behavior.
	//
	// To reject an invalid combination or order of filters, implementations SHOULD
	// consider the Route Rules with this configuration invalid. If all Route Rules
	// in a Route are invalid, the entire Route would be considered invalid. If only
	// a portion of Route Rules are invalid, implementations MUST set the
	// "PartiallyInvalid" condition for the Route.
	//
	// Conformance-levels at this level are defined based on the type of filter:
	//
	//   - ALL core filters MUST be supported by all implementations.
	//   - Implementers are encouraged to support extended filters.
	//   - Implementation-specific custom filters have no API guarantees across
	//     implementations.
	//
	// Specifying the same filter multiple times is not supported unless explicitly
	// indicated in the filter.
	//
	// All filters are expected to be compatible with each other except for the
	// URLRewrite and RequestRedirect filters, which may not be combined. If an
	// implementation cannot support other combinations of filters, they must clearly
	// document that limitation. In cases where incompatible or unsupported
	// filters are specified and cause the `Accepted` condition to be set to status
	// `False`, implementations may use the `IncompatibleFilters` reason to specify
	// this configuration error.
	//
	// Support: Core
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	// +kubebuilder:validation:XValidation:message="May specify either httpRouteFilterRequestRedirect or httpRouteFilterRequestRewrite, but not both",rule="!(self.exists(f, f.type == 'RequestRedirect') && self.exists(f, f.type == 'URLRewrite'))"
	// +kubebuilder:validation:XValidation:message="RequestHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'RequestHeaderModifier').size() <= 1"
	// +kubebuilder:validation:XValidation:message="ResponseHeaderModifier filter cannot be repeated",rule="self.filter(f, f.type == 'ResponseHeaderModifier').size() <= 1"
	// +kubebuilder:validation:XValidation:message="RequestRedirect filter cannot be repeated",rule="self.filter(f, f.type == 'RequestRedirect').size() <= 1"
	// +kubebuilder:validation:XValidation:message="URLRewrite filter cannot be repeated",rule="self.filter(f, f.type == 'URLRewrite').size() <= 1"
	Filters []HTTPRouteFilter `json:"filters,omitempty"`
	// BackendRefs defines the backend(s) where matching requests should be
	// sent.
	//
	// Failure behavior here depends on how many BackendRefs are specified and
	// how many are invalid.
	//
	// If *all* entries in BackendRefs are invalid, and there are also no filters
	// specified in this route rule, *all* traffic which matches this rule MUST
	// receive a 500 status code.
	//
	// See the HTTPBackendRef definition for the rules about what makes a single
	// HTTPBackendRef invalid.
	//
	// When a HTTPBackendRef is invalid, 500 status codes MUST be returned for
	// requests that would have otherwise been routed to an invalid backend. If
	// multiple backends are specified, and some are invalid, the proportion of
	// requests that would otherwise have been routed to an invalid backend
	// MUST receive a 500 status code.
	//
	// For example, if two backends are specified with equal weights, and one is
	// invalid, 50 percent of traffic must receive a 500. Implementations may
	// choose how that 50 percent is determined.
	//
	// When a HTTPBackendRef refers to a Service that has no ready endpoints,
	// implementations SHOULD return a 503 for requests to that backend instead.
	// If an implementation chooses to do this, all of the above rules for 500 responses
	// MUST also apply for responses that return a 503.
	//
	// Support: Core for Kubernetes Service
	//
	// Support: Extended for Kubernetes ServiceImport
	//
	// Support: Implementation-specific for any other resource
	//
	// Support for weight: Core
	//
	// +optional
	// +kubebuilder:validation:MaxItems=16
	BackendRefs []HTTPBackendRef `json:"backendRefs,omitempty"`
}

// HTTPRouteSpec defines the desired state of HTTPRoute
type HTTPRouteSpec struct {
	CommonRouteSpec `json:",inline"`
	// Rules are a list of HTTP matchers, filters and actions.
	//
	// +optional
	// <gateway:experimental:validation:XValidation:message="Rule name must be unique within the route",rule="self.all(l1, !has(l1.name) || self.exists_one(l2, has(l2.name) && l1.name == l2.name))">
	// +kubebuilder:validation:MaxItems=16
	// +kubebuilder:default={{matches: {{path: {type: "PathPrefix", value: "/"}}}}}
	// +kubebuilder:validation:XValidation:message="While 16 rules and 64 matches per rule are allowed, the total number of matches across all rules in a route must be less than 128",rule="(self.size() > 0 ? self[0].matches.size() : 0) + (self.size() > 1 ? self[1].matches.size() : 0) + (self.size() > 2 ? self[2].matches.size() : 0) + (self.size() > 3 ? self[3].matches.size() : 0) + (self.size() > 4 ? self[4].matches.size() : 0) + (self.size() > 5 ? self[5].matches.size() : 0) + (self.size() > 6 ? self[6].matches.size() : 0) + (self.size() > 7 ? self[7].matches.size() : 0) + (self.size() > 8 ? self[8].matches.size() : 0) + (self.size() > 9 ? self[9].matches.size() : 0) + (self.size() > 10 ? self[10].matches.size() : 0) + (self.size() > 11 ? self[11].matches.size() : 0) + (self.size() > 12 ? self[12].matches.size() : 0) + (self.size() > 13 ? self[13].matches.size() : 0) + (self.size() > 14 ? self[14].matches.size() : 0) + (self.size() > 15 ? self[15].matches.size() : 0) <= 128"
	Rules []HTTPRouteRule `json:"rules,omitempty"`
}

// Kind refers to a Kubernetes Kind.
//
// Valid values include:
//
// * "Service"
// * "HTTPRoute"
//
// Invalid values include:
//
// * "invalid/kind" - "/" is an invalid character
//
// +kubebuilder:validation:MinLength=1
// +kubebuilder:validation:MaxLength=63
// +kubebuilder:validation:Pattern=`^[a-zA-Z]([-a-zA-Z0-9]*[a-zA-Z0-9])?$`
type Kind string

// Listener embodies the concept of a logical endpoint where a Gateway accepts
// network connections.
type Listener struct {
	// TLS is the TLS configuration for the Listener. This field is required if
	// the Protocol field is "HTTPS" or "TLS". It is invalid to set this field
	// if the Protocol field is "HTTP", "TCP", or "UDP".
	//
	// The association of SNIs to Certificate defined in GatewayTLSConfig is
	// defined based on the Hostname field for this listener.
	//
	// The GatewayClass MUST use the longest matching SNI out of all
	// available certificates for any TLS handshake.
	//
	// Support: Core
	//
	// +optional
	TLS *GatewayTLSConfig `json:"tls,omitempty"`
}

// LocalObjectReference identifies an API object within the namespace of the
// referrer.
// The API object must be valid in the cluster; the Group and Kind must
// be registered in the cluster for this reference to be valid.
//
// References to objects with invalid Group and Kind are not valid, and must
// be rejected by the implementation, with appropriate Conditions set
// on the containing object.
type LocalObjectReference struct {
	// Group is the group of the referent. For example, "gateway.networking.k8s.io".
	// When unspecified or empty string, core API group is inferred.
	Group Group `json:"group"`
	// Kind is kind of the referent. For example "HTTPRoute" or "Service".
	Kind Kind `json:"kind"`
	// Name is the name of the referent.
	Name ObjectName `json:"name"`
}

// LocalParametersReference identifies an API object containing controller-specific
// configuration resource within the namespace.
type LocalParametersReference struct {
	// Group is the group of the referent.
	Group Group `json:"group"`
	// Kind is kind of the referent.
	Kind Kind `json:"kind"`
	// Name is the name of the referent.
	//
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=253
	Name string `json:"name"`
}

// Namespace refers to a Kubernetes namespace. It must be a RFC 1123 label.
//
// This validation is based off of the corresponding Kubernetes validation:
// https://github.com/kubernetes/apimachinery/blob/02cfb53916346d085a6c6c7c66f882e3c6b0eca6/pkg/util/validation/validation.go#L187
//
// This is used for Namespace name validation here:
// https://github.com/kubernetes/apimachinery/blob/02cfb53916346d085a6c6c7c66f882e3c6b0eca6/pkg/api/validation/generic.go#L63
//
// Valid values include:
//
// * "example"
//
// Invalid values include:
//
// * "example.com" - "." is an invalid character
//
// +kubebuilder:validation:Pattern=`^[a-z0-9]([-a-z0-9]*[a-z0-9])?$`
// +kubebuilder:validation:MinLength=1
// +kubebuilder:validation:MaxLength=63
type Namespace string

// ObjectName refers to the name of a Kubernetes object.
// Object names can have a variety of forms, including RFC 1123 subdomains,
// RFC 1123 labels, or RFC 1035 labels.
//
// +kubebuilder:validation:MinLength=1
// +kubebuilder:validation:MaxLength=253
type ObjectName string

// ObjectReference identifies an API object including its namespace.
//
// The API object must be valid in the cluster; the Group and Kind must
// be registered in the cluster for this reference to be valid.
//
// References to objects with invalid Group and Kind are not valid, and must
// be rejected by the implementation, with appropriate Conditions set
// on the containing object.
type ObjectReference struct {
	// Group is the group of the referent. For example, "gateway.networking.k8s.io".
	// When set to the empty string, core API group is inferred.
	Group Group `json:"group"`
	// Kind is kind of the referent. For example "ConfigMap" or "Service".
	Kind Kind `json:"kind"`
	// Name is the name of the referent.
	Name ObjectName `json:"name"`
	// Namespace is the namespace of the referenced object. When unspecified, the local
	// namespace is inferred.
	//
	// Note that when a namespace different than the local namespace is specified,
	// a ReferenceGrant object is required in the referent namespace to allow that
	// namespace's owner to accept the reference. See the ReferenceGrant
	// documentation for details.
	//
	// Support: Core
	//
	// +optional
	Namespace *Namespace `json:"namespace,omitempty"`
}

// ParametersReference identifies an API object containing controller-specific
// configuration resource within the cluster.
type ParametersReference struct {
	// Group is the group of the referent.
	Group Group `json:"group"`
	// Kind is kind of the referent.
	Kind Kind `json:"kind"`
	// Name is the name of the referent.
	//
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=253
	Name string `json:"name"`
	// Namespace is the namespace of the referent.
	// This field is required when referring to a Namespace-scoped resource and
	// MUST be unset when referring to a Cluster-scoped resource.
	//
	// +optional
	Namespace *Namespace `json:"namespace,omitempty"`
}

// ParentReference identifies an API object (usually a Gateway) that can be considered
// a parent of this resource (usually a route). There are two kinds of parent resources
// with "Core" support:
//
// * Gateway (Gateway conformance profile)
// * Service (Mesh conformance profile, ClusterIP Services only)
//
// This API may be extended in the future to support additional kinds of parent
// resources.
//
// The API object must be valid in the cluster; the Group and Kind must
// be registered in the cluster for this reference to be valid.
type ParentReference struct {
	// Group is the group of the referent.
	// When unspecified, "gateway.networking.k8s.io" is inferred.
	// To set the core API group (such as for a "Service" kind referent),
	// Group must be explicitly set to "" (empty string).
	//
	// Support: Core
	//
	// +kubebuilder:default=gateway.networking.k8s.io
	// +optional
	Group *Group `json:"group,omitempty"`
	// Kind is kind of the referent.
	//
	// There are two kinds of parent resources with "Core" support:
	//
	// * Gateway (Gateway conformance profile)
	// * Service (Mesh conformance profile, ClusterIP Services only)
	//
	// Support for other resources is Implementation-Specific.
	//
	// +kubebuilder:default=Gateway
	// +optional
	Kind *Kind `json:"kind,omitempty"`
	// Namespace is the namespace of the referent. When unspecified, this refers
	// to the local namespace of the Route.
	//
	// Note that there are specific rules for ParentRefs which cross namespace
	// boundaries. Cross-namespace references are only valid if they are explicitly
	// allowed by something in the namespace they are referring to. For example:
	// Gateway has the AllowedRoutes field, and ReferenceGrant provides a
	// generic way to enable any other kind of cross-namespace reference.
	//
	// <gateway:experimental:description>
	// ParentRefs from a Route to a Service in the same namespace are "producer"
	// routes, which apply default routing rules to inbound connections from
	// any namespace to the Service.
	//
	// ParentRefs from a Route to a Service in a different namespace are
	// "consumer" routes, and these routing rules are only applied to outbound
	// connections originating from the same namespace as the Route, for which
	// the intended destination of the connections are a Service targeted as a
	// ParentRef of the Route.
	// </gateway:experimental:description>
	//
	// Support: Core
	//
	// +optional
	Namespace *Namespace `json:"namespace,omitempty"`
	// Name is the name of the referent.
	//
	// Support: Core
	Name ObjectName `json:"name"`
}

// SecretObjectReference identifies an API object including its namespace,
// defaulting to Secret.
//
// The API object must be valid in the cluster; the Group and Kind must
// be registered in the cluster for this reference to be valid.
//
// References to objects with invalid Group and Kind are not valid, and must
// be rejected by the implementation, with appropriate Conditions set
// on the containing object.
type SecretObjectReference struct {
	// Group is the group of the referent. For example, "gateway.networking.k8s.io".
	// When unspecified or empty string, core API group is inferred.
	//
	// +optional
	// +kubebuilder:default=""
	Group *Group `json:"group"`
	// Kind is kind of the referent. For example "Secret".
	//
	// +optional
	// +kubebuilder:default=Secret
	Kind *Kind `json:"kind"`
	// Name is the name of the referent.
	Name ObjectName `json:"name"`
	// Namespace is the namespace of the referenced object. When unspecified, the local
	// namespace is inferred.
	//
	// Note that when a namespace different than the local namespace is specified,
	// a ReferenceGrant object is required in the referent namespace to allow that
	// namespace's owner to accept the reference. See the ReferenceGrant
	// documentation for details.
	//
	// Support: Core
	//
	// +optional
	Namespace *Namespace `json:"namespace,omitempty"`
}
