package storage

import (
	"k8s.io/apimachinery/pkg/runtime/schema"
)

const (
	GroupName = "storage.k8s.io"
)

var (
	StorageClassGK          = gk("StorageClass")
	VolumeAttributesClassGK = gk("VolumeAttributesClass")
)

func gk(kind string) schema.GroupKind {
	return schema.GroupKind{
		Group: GroupName,
		Kind:  kind,
	}
}
