package watch_graph //nolint:staticcheck

import (
	notificationapi "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/github.com/fluxcd/notification-controller/api"
	notificationv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/github.com/fluxcd/notification-controller/api/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) collectFluxCDNotificationControllerReceiverV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[notificationv1.Receiver](obj)
	if err != nil {
		return err
	}

	collectEach(o.Spec.Resources, ReferenceArcType, func(t *notificationv1.CrossNamespaceObjectReference, arcType ArcType) {
		group := notificationapi.GroupName
		if v := t.APIVersion; v != "" {
			gv, err := schema.ParseGroupVersion(t.APIVersion)
			if err != nil {
				vx.appendObjectProcessingWarning(err.Error())
				return
			}
			group = gv.Group
		}

		vx.setArcTo(group, t.Kind, t.Name, t.Namespace, ArcAttrs{}, arcType)
	})

	vx.setArcToSecret(o.Spec.SecretRef.Name, ArcAttrs{}, ReferenceArcType)

	return nil
}
