package watch_graph //nolint:staticcheck

import (
	batchv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/batch/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectCronJobV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[batchv1.CronJob](obj)
	if err != nil {
		return err
	}

	// CronJob transitively references things in the Pod's spec. Hence, use transitive ref type.
	vx.collectPodSpecV1Arcs(&o.Spec.JobTemplate.Spec.Template.Spec, TransitiveReferenceArcType)

	return nil
}
