package watch_graph //nolint:staticcheck

import (
	rbacv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/rbac/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectClusterRoleBindingV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[rbacv1.ClusterRoleBinding](obj)
	if err != nil {
		return err
	}
	vx.setArcTo(o.RoleRef.APIGroup, o.RoleRef.Kind, o.RoleRef.Name, "", ArcAttrs{}, ReferenceArcType)

	collectEach(o.Subjects, ReferenceArcType, vx.collectRBACSubjectV1Arcs)

	return nil
}
