package watch_graph //nolint:staticcheck

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
	"k8s.io/utils/ptr"
)

func (vx *wgObject2vertex) collectOwnerReferencesArcs(obj *unstructured.Unstructured) {
	collectEach(obj.GetOwnerReferences(), OwnerReferenceArcType, vx.ownerReference2arc)
}

func (vx *wgObject2vertex) ownerReference2arc(ref *metav1.OwnerReference, arcType ArcType) {
	gv, err := schema.ParseGroupVersion(ref.APIVersion)
	if err != nil {
		vx.appendObjectProcessingWarning(err.Error())
		return
	}
	arcAttrs := ArcAttrs{
		Controller:         ptr.Deref(ref.Controller, false),
		BlockOwnerDeletion: ptr.Deref(ref.BlockOwnerDeletion, false),
	}
	vx.setArcTo(gv.Group, ref.Kind, ref.Name, "", arcAttrs, arcType)
}
