package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/core"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

func (vx *wgObject2vertex) setArcToConfigMap(name string, arcAttrs ArcAttrs, arcType ArcType) { //nolint:unparam
	vx.setArcToGK(core.ConfigMapGK, name, arcAttrs, arcType)
}

func (vx *wgObject2vertex) setArcToSecret(name string, arcAttrs ArcAttrs, arcType ArcType) { //nolint:unparam
	vx.setArcToSecretNs(name, "", arcAttrs, arcType)
}

func (vx *wgObject2vertex) setArcToSecretNs(name, namespaceOverride string, arcAttrs ArcAttrs, arcType ArcType) {
	vx.setArcToGKNs(core.SecretGK, name, namespaceOverride, arcAttrs, arcType)
}

func (vx *wgObject2vertex) setArcToGK(gk schema.GroupKind, name string, arcAttrs ArcAttrs, arcType ArcType) {
	vx.setArcToGKNs(gk, name, "", arcAttrs, arcType)
}

func (vx *wgObject2vertex) setArcToGKNs(gk schema.GroupKind, name, namespaceOverride string, arcAttrs ArcAttrs, arcType ArcType) {
	arc2id := ArcToID[vertexGKID, ArcType]{
		To: vertexGKID{
			GK:                gk,
			NamespaceOverride: namespaceOverride,
			Name:              name,
		},
		ArcType: arcType,
	}
	vx.setArc(arc2id, arcAttrs)
}

func (vx *wgObject2vertex) setArcTo(group, kind, name, namespaceOverride string, arcAttrs ArcAttrs, arcType ArcType) {
	vx.setArcToGKNs(schema.GroupKind{Group: group, Kind: kind}, name, namespaceOverride, arcAttrs, arcType)
}

func (vx *wgObject2vertex) setArc(arc2id ArcToID[vertexGKID, ArcType], arcAttrs ArcAttrs) {
	if vx.arcSet == nil { // allocate the map lazily, only when needed.
		vx.arcSet = make(ArcSetWithData[vertexGKID, ArcType, ArcAttrs])
	}
	vx.arcSet[arc2id] = arcAttrs
}

func collectEach[T any](vals []T, arcType ArcType, f func(*T, ArcType)) {
	for i := range vals {
		f(&vals[i], arcType) // avoid copying, just pass a pointer
	}
}
