package server

import (
	"net/url"
	"time"
)

func (osp *OAuthStateParam) IsValid(ttl time.Duration) bool {
	return time.Since(osp.CreatedAt.AsTime()) <= ttl
}

func (oauthState *OAuthState) IsValid(ttl time.Duration, state string) bool {
	return time.Since(oauthState.CreatedAt.AsTime()) <= ttl && oauthState.StateValue == state
}

func (te *TransferError) IsValid(host string) (bool, error) {
	originalHost, err := url.Parse(te.OriginalUrl)
	if err != nil {
		return false, err
	}
	return originalHost.Host == host, nil
}

func (tt *TransferToken) IsValid(ttl time.Duration, host string) (bool, error) {
	originalHost, err := url.Parse(tt.OriginalUrl)
	if err != nil {
		return false, err
	}
	return time.Since(tt.CreatedAt.AsTime()) <= ttl && originalHost.Host == host, nil
}

func (us *UserSession) IsValid(ttl time.Duration, host string) bool {
	return time.Since(us.CreatedAt.AsTime()) <= ttl && us.Host == host
}
