package runner_controller //nolint:staticcheck

import (
	"context"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/api"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/runner_controller/rpc"
	"google.golang.org/grpc"
)

type RunnerControllerClient struct {
	agentConnPool func(agentKey api.AgentKey) grpc.ClientConnInterface
}

func NewRunnerControllerClient(agentConnPool func(agentKey api.AgentKey) grpc.ClientConnInterface) *RunnerControllerClient {
	return &RunnerControllerClient{
		agentConnPool: agentConnPool,
	}
}

func (c *RunnerControllerClient) Admit(ctx context.Context, agentKey api.AgentKey, req *rpc.AdmitRequest) (*rpc.AdmitResponse, error) {
	client := rpc.NewRunnerControllerServiceClient(c.agentConnPool(agentKey))
	return client.Admit(ctx, req, grpc.WaitForReady(true))
}
