package agentk

import (
	"context"

	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

type namespaceHandler interface {
	IsTerminated(ctx context.Context, info *WorkspaceRailsInfo, inventories []*unstructured.Unstructured) (bool, error)
	Terminate(ctx context.Context, info *WorkspaceRailsInfo, inventories []*unstructured.Unstructured) <-chan *ErrorDetails
	Create(ctx context.Context, info *WorkspaceRailsInfo) <-chan *ErrorDetails
}
