package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	GroupName  = "events.k8s.io"
	Version    = "v1"
	APIVersion = GroupName + "/" + Version
)

var (
	EventTypeMeta = tm("Event")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
