//go:build !ignore_autogenerated

// Code generated by remove-junk-from-types-now-9000; DO NOT EDIT.
// Generator module: gitlab.com/gitlab-org/cluster-integration/remove-junk-from-types-now-9000
// Generator version: v0.0.0-20251110001802-ac4f0ee40261
// Configuration file: no_junk_config.json
// Source module: github.com/fluxcd/helm-controller/api
// Source module version: v1.3.0
// Source module query:
// Source module sum: h1:PupXPuQbksmU0g2Lc6NjIYal2HJGL+6xohsf82eGVjo=
// Source module package: v2

package v2

import (
	meta "github.com/fluxcd/pkg/apis/meta"
	kustomize "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/github.com/fluxcd/pkg/apis/kustomize"
)

// CrossNamespaceObjectReference contains enough information to let you locate
// the typed referenced object at cluster level.
type CrossNamespaceObjectReference struct {
	// APIVersion of the referent.
	// +optional
	APIVersion string `json:"apiVersion,omitempty"`
	// Kind of the referent.
	// +kubebuilder:validation:Enum=HelmRepository;GitRepository;Bucket
	// +required
	Kind string `json:"kind,omitempty"`
	// Name of the referent.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=253
	// +required
	Name string `json:"name"`
	// Namespace of the referent.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=63
	// +kubebuilder:validation:Optional
	// +optional
	Namespace string `json:"namespace,omitempty"`
}

// CrossNamespaceSourceReference contains enough information to let you locate
// the typed referenced object at cluster level.
type CrossNamespaceSourceReference struct {
	// APIVersion of the referent.
	// +optional
	APIVersion string `json:"apiVersion,omitempty"`
	// Kind of the referent.
	// +kubebuilder:validation:Enum=OCIRepository;HelmChart
	// +required
	Kind string `json:"kind"`
	// Name of the referent.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=253
	// +required
	Name string `json:"name"`
	// Namespace of the referent, defaults to the namespace of the Kubernetes
	// resource object that contains the reference.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=63
	// +kubebuilder:validation:Optional
	// +optional
	Namespace string `json:"namespace,omitempty"`
}

// DriftDetection defines the strategy for performing differential analysis and
// provides a way to define rules for ignoring specific changes during this
// process.
type DriftDetection struct {
	// Ignore contains a list of rules for specifying which changes to ignore
	// during diffing.
	// +optional
	Ignore []IgnoreRule `json:"ignore,omitempty"`
}

// HelmChartTemplate defines the template from which the controller will
// generate a v1.HelmChart object in the same namespace as the referenced
// v1.Source.
type HelmChartTemplate struct {
	// Spec holds the template for the v1.HelmChartSpec for this HelmRelease.
	// +required
	Spec HelmChartTemplateSpec `json:"spec"`
}

// HelmChartTemplateSpec defines the template from which the controller will
// generate a v1.HelmChartSpec object.
type HelmChartTemplateSpec struct {
	// The name and namespace of the v1.Source the chart is available at.
	// +required
	SourceRef CrossNamespaceObjectReference `json:"sourceRef"`
	// Verify contains the secret name containing the trusted public keys
	// used to verify the signature and specifies which provider to use to check
	// whether OCI image is authentic.
	// This field is only supported for OCI sources.
	// Chart dependencies, which are not bundled in the umbrella chart artifact,
	// are not verified.
	// +optional
	Verify *HelmChartTemplateVerification `json:"verify,omitempty"`
}

// HelmChartTemplateVerification verifies the authenticity of an OCI Helm chart.
type HelmChartTemplateVerification struct {
	// SecretRef specifies the Kubernetes Secret containing the
	// trusted public keys.
	// +optional
	SecretRef *meta.LocalObjectReference `json:"secretRef,omitempty"`
}

// HelmRelease is the Schema for the helmreleases API
type HelmRelease struct {
	Spec HelmReleaseSpec `json:"spec,omitempty"`
}

// HelmReleaseSpec defines the desired state of a Helm release.
// +kubebuilder:validation:XValidation:rule="(has(self.chart) && !has(self.chartRef)) || (!has(self.chart) && has(self.chartRef))", message="either chart or chartRef must be set"
type HelmReleaseSpec struct {
	// Chart defines the template of the v1.HelmChart that should be created
	// for this HelmRelease.
	// +optional
	Chart *HelmChartTemplate `json:"chart,omitempty"`
	// ChartRef holds a reference to a source controller resource containing the
	// Helm chart artifact.
	// +optional
	ChartRef *CrossNamespaceSourceReference `json:"chartRef,omitempty"`
	// KubeConfig for reconciling the HelmRelease on a remote cluster.
	// When used in combination with HelmReleaseSpec.ServiceAccountName,
	// forces the controller to act on behalf of that Service Account at the
	// target cluster.
	// If the --default-service-account flag is set, its value will be used as
	// a controller level fallback for when HelmReleaseSpec.ServiceAccountName
	// is empty.
	// +optional
	KubeConfig *meta.KubeConfigReference `json:"kubeConfig,omitempty"`
	// TargetNamespace to target when performing operations for the HelmRelease.
	// Defaults to the namespace of the HelmRelease.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=63
	// +kubebuilder:validation:Optional
	// +optional
	TargetNamespace string `json:"targetNamespace,omitempty"`
	// StorageNamespace used for the Helm storage.
	// Defaults to the namespace of the HelmRelease.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=63
	// +kubebuilder:validation:Optional
	// +optional
	StorageNamespace string `json:"storageNamespace,omitempty"`
	// DependsOn may contain a meta.NamespacedObjectReference slice with
	// references to HelmRelease resources that must be ready before this HelmRelease
	// can be reconciled.
	// +optional
	DependsOn []meta.NamespacedObjectReference `json:"dependsOn,omitempty"`
	// The name of the Kubernetes service account to impersonate
	// when reconciling this HelmRelease.
	// +kubebuilder:validation:MinLength=1
	// +kubebuilder:validation:MaxLength=253
	// +optional
	ServiceAccountName string `json:"serviceAccountName,omitempty"`
	// DriftDetection holds the configuration for detecting and handling
	// differences between the manifest in the Helm storage and the resources
	// currently existing in the cluster.
	// +optional
	DriftDetection *DriftDetection `json:"driftDetection,omitempty"`
	// ValuesFrom holds references to resources containing Helm values for this HelmRelease,
	// and information about how they should be merged.
	ValuesFrom []meta.ValuesReference `json:"valuesFrom,omitempty"`
	// PostRenderers holds an array of Helm PostRenderers, which will be applied in order
	// of their definition.
	// +optional
	PostRenderers []PostRenderer `json:"postRenderers,omitempty"`
}

// IgnoreRule defines a rule to selectively disregard specific changes during
// the drift detection process.
type IgnoreRule struct {
	// Target is a selector for specifying Kubernetes objects to which this
	// rule applies.
	// If Target is not set, the Paths will be ignored for all Kubernetes
	// objects within the manifest of the Helm release.
	// +optional
	Target *kustomize.Selector `json:"target,omitempty"`
}

// Kustomize Helm PostRenderer specification.
type Kustomize struct {
	// Strategic merge and JSON patches, defined as inline YAML objects,
	// capable of targeting objects based on kind, label and annotation selectors.
	// +optional
	Patches []kustomize.Patch `json:"patches,omitempty"`
}

// PostRenderer contains a Helm PostRenderer specification.
type PostRenderer struct {
	// Kustomization to apply as PostRenderer.
	// +optional
	Kustomize *Kustomize `json:"kustomize,omitempty"`
}
