package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/core"
	rbacv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/rbac/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectRoleBindingV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[rbacv1.RoleBinding](obj)
	if err != nil {
		return err
	}
	vx.setArcTo(o.RoleRef.APIGroup, o.RoleRef.Kind, o.RoleRef.Name, "", ArcAttrs{}, ReferenceArcType)

	collectEach(o.Subjects, ReferenceArcType, vx.collectRBACSubjectV1Arcs)

	return nil
}

func (vx *wgObject2vertex) collectRBACSubjectV1Arcs(s *rbacv1.Subject, arcType ArcType) {
	switch s.Kind {
	case "ServiceAccount":
		vx.setArcToGKNs(core.ServiceAccountGK, s.Name, s.Namespace, ArcAttrs{}, arcType)
	}
}
