package watch_graph //nolint:staticcheck

import (
	gatewayapis "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/sigs.k8s.io/gateway-api/apis"
	gatewayapiv1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/sigs.k8s.io/gateway-api/apis/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectGatewayV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[gatewayapiv1.Gateway](obj)
	if err != nil {
		return err
	}

	if o.Spec.GatewayClassName != "" {
		vx.setArcToGK(gatewayapis.GatewayClassGK, string(o.Spec.GatewayClassName), ArcAttrs{}, ReferenceArcType)
	}

	collectEach(o.Spec.Listeners, ReferenceArcType, func(l *gatewayapiv1.Listener, arcType ArcType) {
		if l.TLS != nil {
			collectEach(l.TLS.CertificateRefs, arcType, vx.collectGatewaySecretRefV1Arcs)
			if l.TLS.FrontendValidation != nil {
				collectEach(l.TLS.FrontendValidation.CACertificateRefs, arcType, vx.collectGatewayObjectRefV1Arcs)
			}
		}
	})

	if o.Spec.Infrastructure != nil && o.Spec.Infrastructure.ParametersRef != nil {
		vx.collectGatewayLocalParametersRefV1Arcs(o.Spec.Infrastructure.ParametersRef, ReferenceArcType)
	}

	if o.Spec.BackendTLS != nil && o.Spec.BackendTLS.ClientCertificateRef != nil {
		vx.collectGatewaySecretRefV1Arcs(o.Spec.BackendTLS.ClientCertificateRef, ReferenceArcType)
	}

	return nil
}
