package watch_graph //nolint:staticcheck

import (
	sourcev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/github.com/fluxcd/source-controller/api/v1"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/core"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectFluxCDSourceControllerOCIRepositoryV1(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[sourcev1.OCIRepository](obj)
	if err != nil {
		return err
	}

	if o.Spec.SecretRef != nil {
		vx.setArcToSecret(o.Spec.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.Verify != nil && o.Spec.Verify.SecretRef != nil {
		vx.setArcToSecret(o.Spec.Verify.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.ServiceAccountName != "" {
		vx.setArcToGK(core.ServiceAccountGK, o.Spec.ServiceAccountName, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.CertSecretRef != nil {
		vx.setArcToSecret(o.Spec.CertSecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.ProxySecretRef != nil {
		vx.setArcToSecret(o.Spec.ProxySecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	return nil
}
