package watch_graph //nolint:staticcheck

import (
	notificationv1beta3 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/github.com/fluxcd/notification-controller/api/v1beta3"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/core"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
)

func (vx *wgObject2vertex) collectFluxCDNotificationControllerProviderV1Beta3(obj *unstructured.Unstructured) *Error {
	o, err := unstructuredToTyped[notificationv1beta3.Provider](obj)
	if err != nil {
		return err
	}

	if o.Spec.SecretRef != nil {
		vx.setArcToSecret(o.Spec.SecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.CertSecretRef != nil {
		vx.setArcToSecret(o.Spec.CertSecretRef.Name, ArcAttrs{}, ReferenceArcType)
	}

	if o.Spec.ServiceAccountName != "" {
		vx.setArcToGK(core.ServiceAccountGK, o.Spec.ServiceAccountName, ArcAttrs{}, ReferenceArcType)
	}

	return nil
}
