package watch_graph //nolint:staticcheck

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/core"
	corev1 "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agentk/watch_graph/vendored/k8s.io/api/core/v1"
)

func (vx *wgObject2vertex) collectVolumeV1Arcs(v *corev1.Volume, arcType ArcType) {
	// Only a single field is set.
	switch {
	case v.Secret != nil:
		vx.setArcToSecret(v.Secret.SecretName, ArcAttrs{}, arcType)
	case v.ISCSI != nil:
		if v.ISCSI.SecretRef != nil {
			vx.setArcToSecret(v.ISCSI.SecretRef.Name, ArcAttrs{}, arcType)
		}
	case v.PersistentVolumeClaim != nil:
		vx.setArcToGK(core.PersistentVolumeClaimGK, v.PersistentVolumeClaim.ClaimName, ArcAttrs{}, arcType)
	case v.ConfigMap != nil:
		vx.setArcToConfigMap(v.ConfigMap.Name, ArcAttrs{}, arcType)
	case v.Projected != nil:
		collectEach(v.Projected.Sources, arcType, vx.collectVolumeProjectionV1Arcs)
	case v.CSI != nil:
		if v.CSI.NodePublishSecretRef != nil {
			vx.setArcToSecret(v.CSI.NodePublishSecretRef.Name, ArcAttrs{}, arcType)
		}
	case v.Ephemeral != nil:
		vx.collectPersistentVolumeClaimSpecV1Arcs(&v.Ephemeral.VolumeClaimTemplate.Spec, arcType)
	}
}

func (vx *wgObject2vertex) collectVolumeProjectionV1Arcs(p *corev1.VolumeProjection, arcType ArcType) {
	switch {
	case p.Secret != nil:
		vx.setArcToSecret(p.Secret.Name, ArcAttrs{}, arcType)
	case p.ConfigMap != nil:
		vx.setArcToConfigMap(p.ConfigMap.Name, ArcAttrs{}, arcType)
	case p.ClusterTrustBundle != nil:
		if p.ClusterTrustBundle.Name != nil {
			vx.setArcToGK(clusterTrustBundleGK, *p.ClusterTrustBundle.Name, ArcAttrs{}, arcType)
		}
	}
}
