package watch_graph //nolint:staticcheck

import (
	"testing"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/apis/meta/v1/unstructured"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

var (
	gvk schema.GroupVersionKind
	tm  metav1.TypeMeta
)

func BenchmarkGVKvsTypMeta(b *testing.B) {
	u := &unstructured.Unstructured{
		Object: map[string]any{
			"apiVersion": "apps/v1",
			"kind":       "Deployment",
		},
	}
	b.Run("GVK", func(b *testing.B) {
		b.ReportAllocs()
		for b.Loop() {
			gvk = u.GetObjectKind().GroupVersionKind()
		}
	})
	b.Run("TypeMeta", func(b *testing.B) {
		b.ReportAllocs()
		for b.Loop() {
			tm = metav1.TypeMeta{
				Kind:       u.GetKind(),
				APIVersion: u.GetAPIVersion(),
			}
		}
	})
}
