package agentw

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/agentwcfg"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/google_profiler/agent"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modagentw"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/prototool"
)

type Factory struct {
	agent.Factory
}

func (f *Factory) New(config *modagentw.Config) (modagentw.Module, error) {
	return &agent.Module[*agentwcfg.AgentConfiguration]{
		Log: config.Log,
		Runner: &agent.GoogleProfilerRunner{
			Service: config.AgentName,
			Version: config.AgentMeta.Version,
		},
		CfgAccessor: func(cfg *agentwcfg.AgentConfiguration) *agent.ModuleCfg {
			profilerCfg := cfg.Observability.GoogleProfiler
			return &agent.ModuleCfg{
				ProfilerCfg: agent.ProfilerCfg{
					Enabled:         profilerCfg.Enabled,
					ProjectID:       profilerCfg.ProjectId,
					CredentialsFile: profilerCfg.CredentialsFile,
					DebugLogging:    profilerCfg.DebugLogging,
				},
			}
		},
		DefaultAndValidateConfigurationCallback: func(cfg *agentwcfg.AgentConfiguration) error {
			prototool.NotNil(&cfg.Observability)
			prototool.NotNil(&cfg.Observability.GoogleProfiler)
			return nil
		},
	}, nil
}
