package agentk

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/google_profiler/agent"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modagentk"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/prototool"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/agentcfg"
)

type Factory struct {
	agent.Factory
}

func (f *Factory) New(config *modagentk.Config) (modagentk.Module, error) {
	return &agent.Module[*agentcfg.AgentConfiguration]{
		Log: config.Log,
		Runner: &agent.GoogleProfilerRunner{
			Service: config.AgentName,
			Version: config.AgentMeta.Version,
		},
		CfgAccessor: func(cfg *agentcfg.AgentConfiguration) *agent.ModuleCfg {
			profilerCfg := cfg.Observability.GoogleProfiler
			return &agent.ModuleCfg{
				ProfilerCfg: agent.ProfilerCfg{
					Enabled:         profilerCfg.Enabled,
					ProjectID:       profilerCfg.ProjectId,
					CredentialsFile: profilerCfg.CredentialsFile,
					DebugLogging:    profilerCfg.DebugLogging,
				},
			}
		},
		DefaultAndValidateConfigurationCallback: func(cfg *agentcfg.AgentConfiguration) error {
			prototool.NotNil(&cfg.Observability)
			prototool.NotNil(&cfg.Observability.GoogleProfiler)
			return nil
		},
	}, nil
}
