package server

import (
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/prototool"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/kascfg"
)

const (
	defaultCodecServerListenNetwork = "tcp"
	defaultCodecServerListenAddress = ":8142"
)

func ApplyDefaults(config *kascfg.ConfigurationFile) {
	if config.Autoflow == nil { // module disabled. This is temporary.
		return
	}

	if config.Autoflow.Temporal == nil || config.Autoflow.Temporal.WorkflowDataEncryption == nil {
		return
	}

	prototool.NotNil(&config.Autoflow.Temporal.WorkflowDataEncryption.CodecServer)
	prototool.NotNil(&config.Autoflow.Temporal.WorkflowDataEncryption.CodecServer.Listen)
	prototool.DefaultValPtr(&config.Autoflow.Temporal.WorkflowDataEncryption.CodecServer.Listen.Network, defaultCodecServerListenNetwork)
	prototool.DefaultVal(&config.Autoflow.Temporal.WorkflowDataEncryption.CodecServer.Listen.Address, defaultCodecServerListenAddress)
}
