package agent

import (
	"log/slog"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modshared"
	"gitlab.com/gitlab-org/cluster-integration/tunnel/tool/grpcz"
)

var (
	_ modshared.RPCAPI = (*agentRPCAPI)(nil)
)

type agentRPCAPI struct {
	modshared.RPCAPIStub
}

func (a *agentRPCAPI) HandleProcessingError(log *slog.Logger, msg string, err error, fields ...slog.Attr) {
	handleProcessingError(a.StreamCtx, log, msg, err, fields...)
}

func (a *agentRPCAPI) HandleIOError(log *slog.Logger, msg string, err error) error {
	// The problem is almost certainly with the client's connection.
	// Still log it on Debug.
	return grpcz.HandleIOError(log, msg, err)
}
