package redistool

import (
	"context"
	"crypto/tls"
	"net"

	"github.com/redis/rueidis"
)

func MultiErrors(resp []rueidis.RedisResult) []error {
	var errs []error
	for _, r := range resp {
		if err := r.Error(); err != nil {
			errs = append(errs, err)
		}
	}
	return errs
}

// UnixDialer can be used as DialCtxFn in rueidis.ClientOption.
func UnixDialer(ctx context.Context, addr string, dialer *net.Dialer, tlsConfig *tls.Config) (net.Conn, error) {
	return dialer.DialContext(ctx, "unix", addr)
}
