package logz

import (
	"net/http"
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestLogz_ResponseHeaders(t *testing.T) {
	// GIVEN
	h := http.Header{}
	for i := range 19 {
		h.Add(strconv.Itoa(i), "any")
	}

	// WHEN
	attrs := ResponseHeaders(h)

	// THEN
	assert.Len(t, attrs, 19)
}

func TestLogz_ResponseHeaders_Max(t *testing.T) {
	// GIVEN
	h := http.Header{}
	for i := range 25 {
		h.Add(strconv.Itoa(i), "any")
	}

	// WHEN
	attrs := ResponseHeaders(h)

	// THEN
	assert.Len(t, attrs, maxResponseHeaders)
}
