package server

import (
	"time"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/tool/prototool"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/pkg/kascfg"
)

const (
	defaultAPIListenNetwork    = "tcp"
	defaultAPIListenAddress    = ":8160"
	defaultListenGracePeriod   = 5 * time.Second
	defaultShutdownGracePeriod = 1 * time.Hour
)

func ApplyDefaults(config *kascfg.ConfigurationFile) {
	prototool.NotNil(&config.Workspaces)
	prototool.NotNil(&config.Workspaces.Listen)

	prototool.DefaultValPtr(&config.Workspaces.Listen.Network, defaultAPIListenNetwork)
	prototool.DefaultVal(&config.Workspaces.Listen.Address, defaultAPIListenAddress)
	prototool.Duration(&config.Workspaces.Listen.ListenGracePeriod, defaultListenGracePeriod)
	prototool.Duration(&config.Workspaces.Listen.ShutdownGracePeriod, defaultShutdownGracePeriod)
}
