package agent

import (
	"net/http"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/modagentw"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/workspaces"
	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/workspaces/rpc"
)

type Factory struct{}

func (f *Factory) IsProducingLeaderModules() bool {
	return false
}

func (f *Factory) New(config *modagentw.Config) (modagentw.Module, error) {
	tunnelSrv := newTunnelServer(
		config.Log,
		http.DefaultTransport,
		config.Validator,
		config.AgentNameVersion,
		config.AgentMeta.Version,
		"gRPC/1.0 "+config.AgentNameVersion,
	)
	rpc.RegisterWorkspacesServer(config.APIServer, tunnelSrv)

	return &module{
		log: config.Log,
	}, nil
}

func (f *Factory) Name() string {
	return workspaces.ModuleName
}
