package agent_test

import (
	"context"
	"testing"
	"time"

	"gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/starboard_vulnerability/agent"
	"go.uber.org/mock/gomock"
)

func TestScheduler(t *testing.T) {
	ctrl := gomock.NewController(t)
	ctx, cancel := context.WithCancel(context.Background())

	schedule := agent.NewMockSchedule(ctrl)
	schedule.EXPECT().Next(gomock.Any()).
		AnyTimes().
		DoAndReturn(func(t time.Time) time.Time {
			return t // run now
		})

	// Create a test job which calls the cancel func.
	// We'll know this is working correctly if `Run` cancels instead of blocking.
	job := &agent.TestJob{
		RunFunc: cancel,
	}

	scheduler := agent.NewCronScheduler()
	scheduler.Schedule(ctx, schedule, job)
	scheduler.Run(ctx)
}
