package v1

import (
	gatewayapis "gitlab.com/gitlab-org/cluster-integration/gitlab-agent/v18/internal/module/kubernetes_api/agent/watch_graph/vendored/sigs.k8s.io/gateway-api/apis"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

const (
	Version    = "v1"
	APIVersion = gatewayapis.GroupName + "/" + Version
)

var (
	GatewayTypeMeta      = tm("Gateway")
	GatewayClassTypeMeta = tm("GatewayClass")
	HTTPRouteTypeMeta    = tm("HTTPRoute")
	GRPCRouteTypeMeta    = tm("GRPCRoute")
)

func tm(kind string) metav1.TypeMeta {
	return metav1.TypeMeta{
		APIVersion: APIVersion,
		Kind:       kind,
	}
}
